package mods.immibis.autofood;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import mods.immibis.core.TileBasicInventory;

public class AutoFeederTile extends TileBasicInventory implements ISidedInventory {
	public AutoFeederTile() {
		super(2, "autofeeder");
	}
	
	// slot 0: food
	// slot 1: range extenders (plain golden apples)
	
	// max range is BASE_RANGE + 64 / EXTENDERS_PER_BLOCK = 24 (covering 49x49x49 cube)
	public static final int BASE_RANGE = 8;
	public static final int EXTENDERS_PER_BLOCK = 4;
	
	public static final int SCAN_INTERVAL = 40;
	public static final int RESCAN_INTERVAL = 5; // used if someone is successfully healed 
	
	private int timer;
	
	@Override
	public void validate() {
		super.validate();
		
		timer = worldObj.rand.nextInt(SCAN_INTERVAL);
	}
	
	public int getRange() {
		ItemStack extenders = inv.contents[1];
		return BASE_RANGE + (extenders != null && extenders.getItem() == Items.golden_apple && extenders.getItemDamage() == 0 ? extenders.stackSize / EXTENDERS_PER_BLOCK : 0);
	}
	
	@Override
	public void updateEntity() {
		super.updateEntity();
		if(worldObj.isRemote)
			return;
		
		if(--timer <= 0) {
			
			ItemStack foodStack = inv.contents[0];
			
			if(foodStack == null || !(foodStack.getItem() instanceof ItemFood)) {
				timer = RESCAN_INTERVAL;
				return;
			}
			
			ItemFood item = (ItemFood)foodStack.getItem();
			
			timer = SCAN_INTERVAL;
			
			double range = getRange() + 0.5;
			double x = xCoord + 0.5;
			double y = yCoord + 0.5;
			double z = zCoord + 0.5;
			
			List<EntityPlayer> players = (List<EntityPlayer>)worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox(x-range, y-range, z-range, x+range, y+range, z+range));
			
			for(EntityPlayer p : players) {
				if(p.getFoodStats().needFood()) {
					p.getFoodStats().func_151686_a(item, foodStack);
					timer = RESCAN_INTERVAL;
					if(--foodStack.stackSize <= 0)
						break;
				}
			}
			
			if(foodStack.stackSize <= 0)
				inv.contents[0] = null;
		}
	}
	
	@Override
	public boolean canExtractItem(int i, ItemStack itemstack, int j) {
		return true;
	}
	
	@Override
	public boolean canInsertItem(int i, ItemStack itemstack, int j) {
		return true;
	}
	
	private static int[] accSlots = {0};
	@Override
	public int[] getAccessibleSlotsFromSide(int var1) {
		return accSlots;
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(!worldObj.isRemote)
			player.openGui(AutoFood.INSTANCE, AutoFood.GUI_AUTOFEEDER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
}
