/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.client.util.Colors;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;

public class ItemUtil {
    public static ItemStack getWrittenBook(String name, String author, boolean isLocalized, String ... pages) {
        if (pages == null || pages.length == 0) {
            return null;
        }
        ItemStack item = new ItemStack(Items.field_151164_bB);
        item.func_77983_a("author", (NBTBase)new NBTTagString(author));
        item.func_77983_a("title", (NBTBase)new NBTTagString(isLocalized ? StatCollector.func_74838_a((String)name) : name));
        NBTTagList pagesList = new NBTTagList();
        for (int i = 0; i < pages.length; ++i) {
            String str = null;
            str = !pages[i].contains("chapter") ? (isLocalized ? StatCollector.func_74838_a((String)pages[i]) : pages[i]) : Colors.BOLD.toString() + (Object)((Object)Colors.UNDERLINE) + (isLocalized ? StatCollector.func_74838_a((String)pages[i]) : pages[i]);
            pagesList.func_74742_a((NBTBase)new NBTTagString(str));
        }
        item.func_77983_a("pages", (NBTBase)pagesList);
        return item;
    }

    @Deprecated
    public static boolean areItemsSame(ItemStack item1, ItemStack item2) {
        return ItemUtil.areItemsSameMatching(item1, item2, ItemMatchCriteria.ID, ItemMatchCriteria.DAMAGE, ItemMatchCriteria.NBT);
    }

    public static boolean areItemsSameMatching(ItemStack item1, ItemStack item2, ItemMatchCriteria ... crits) {
        if (crits == null || crits.length <= 0) {
            return true;
        }
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        for (ItemMatchCriteria crit : crits) {
            if (crit.checkFor(item1, item2)) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<ItemStack> getItemsFromClass(Class<?> claSS) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (item == null || !claSS.isInstance(item)) continue;
            list.add(new ItemStack(item, 1, Short.MAX_VALUE));
        }
        for (Block block : Block.field_149771_c) {
            if (block == null || !claSS.isInstance(block)) continue;
            list.add(new ItemStack(block, 1, Short.MAX_VALUE));
        }
        return list;
    }

    public static enum ItemMatchCriteria {
        NBT(MatchNBT.class),
        ID(MatchID.class),
        CLASS(MatchCLASS.class),
        DAMAGE(MatchDAMAGE.class),
        WILDCARD(MatchWILDCARD.class);

        private ICompareItems comparer;

        private ItemMatchCriteria(Class<? extends ICompareItems> clazz) {
            try {
                this.comparer = clazz.newInstance();
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }

        private boolean checkFor(ItemStack item1, ItemStack item2) {
            return this.comparer.checkFor(item1, item2);
        }

        static class MatchWILDCARD
        implements ICompareItems {
            MatchWILDCARD() {
            }

            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return ID.checkFor(item1, item2) && (DAMAGE.checkFor(item1, item2) || item1.func_77960_j() == Short.MAX_VALUE || item2.func_77960_j() == Short.MAX_VALUE);
            }
        }

        static class MatchDAMAGE
        implements ICompareItems {
            MatchDAMAGE() {
            }

            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return item1.func_77960_j() == item2.func_77960_j();
            }
        }

        static class MatchCLASS
        implements ICompareItems {
            MatchCLASS() {
            }

            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return item1.func_77973_b().getClass().equals(item2.func_77973_b().getClass());
            }
        }

        static class MatchNBT
        implements ICompareItems {
            MatchNBT() {
            }

            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2);
            }
        }

        static class MatchID
        implements ICompareItems {
            MatchID() {
            }

            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return Item.field_150901_e.func_148750_c((Object)item1.func_77973_b()) == Item.field_150901_e.func_148750_c((Object)item2.func_77973_b());
            }
        }

        static interface ICompareItems {
            public boolean checkFor(ItemStack var1, ItemStack var2);
        }
    }
}

