/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.armorstatushud;

import bspkrs.client.util.ColorThreshold;
import bspkrs.client.util.HUDUtils;
import bspkrs.util.BSConfiguration;
import bspkrs.util.BSLog;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ArmorStatusHUD {
    public static final String VERSION_NUMBER = "v1.17(1.7.2)";
    private static final String DEFAULT_COLOR_LIST = "100,f; 80,7; 60,e; 40,6; 25,c; 10,4";
    public static String alignMode = "bottomleft";
    public static boolean enableItemName = false;
    public static boolean showItemOverlay = true;
    public static String damageColorList = "100,f; 80,7; 60,e; 40,6; 25,c; 10,4";
    public static String damageDisplayType = "value";
    public static String damageThresholdType = "percent";
    public static boolean showMaxDamage = false;
    public static boolean showEquippedItem = true;
    public static int xOffset = 2;
    public static int yOffset = 2;
    public static int yOffsetBottomCenter = 41;
    public static boolean applyXOffsetToCenter = false;
    public static boolean applyYOffsetToMiddle = false;
    public static boolean showInChat = false;
    private static RenderItem itemRenderer = new RenderItem();
    protected static float zLevel = -110.0f;
    private static ScaledResolution scaledResolution;
    private static final List<ColorThreshold> colorList;
    private static BSConfiguration config;

    public static void loadConfig(File file) {
        String ctgyGen = "general";
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        config = new BSConfiguration(file);
        config.load();
        alignMode = config.getString("alignMode", ctgyGen, alignMode, "Valid alignment strings are topleft, topcenter, topright, middleleft, middlecenter, middleright, bottomleft, bottomcenter, bottomright");
        enableItemName = config.getBoolean("enableItemName", ctgyGen, enableItemName, "Set to true to show item names, false to disable");
        showItemOverlay = config.getBoolean("showItemOverlay", ctgyGen, showItemOverlay, "Set to true to show the standard inventory item overlay (damage bar)");
        damageColorList = config.getString("damageColorList", ctgyGen, damageColorList, "This is a list of percent damage thresholds and text color codes that will be used when item damage is <= the threshold. Format used: \",\" separates the threshold and the color code, \";\" separates each pair. Valid color values are 0-9, a-f (color values can be found here: http://www.minecraftwiki.net/wiki/File:Colors.png)");
        damageDisplayType = config.getString("damageDisplayType", ctgyGen, damageDisplayType, "Valid damageDisplayType strings are value, percent, or none");
        damageThresholdType = config.getString("damageThresholdType", ctgyGen, damageThresholdType, "The type of threshold to use when applying the damageColorList thresholds. Valid values are \"percent\" and \"value\".");
        showMaxDamage = config.getBoolean("showMaxDamage", ctgyGen, showMaxDamage, "Set to true to show the max damage when damageDisplayType=value");
        showEquippedItem = config.getBoolean("showEquippedItem", ctgyGen, showEquippedItem, "Set to true to show info for your currently equipped item, false to disable");
        xOffset = config.getInt("xOffset", ctgyGen, xOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Horizontal offset from the edge of the screen (when using right alignments the x offset is relative to the right edge of the screen)");
        yOffset = config.getInt("yOffset", ctgyGen, yOffset, Integer.MIN_VALUE, Integer.MAX_VALUE, "Vertical offset from the edge of the screen (when using bottom alignments the y offset is relative to the bottom edge of the screen)");
        yOffsetBottomCenter = config.getInt("yOffsetBottomCenter", ctgyGen, yOffsetBottomCenter, Integer.MIN_VALUE, Integer.MAX_VALUE, "Vertical offset used only for the bottomcenter alignment to avoid the vanilla HUD");
        applyXOffsetToCenter = config.getBoolean("applyXOffsetToCenter", ctgyGen, applyXOffsetToCenter, "Set to true if you want the xOffset value to be applied when using a center alignment");
        applyYOffsetToMiddle = config.getBoolean("applyYOffsetToMiddle", ctgyGen, applyYOffsetToMiddle, "Set to true if you want the yOffset value to be applied when using a middle alignment");
        showInChat = config.getBoolean("showInChat", ctgyGen, showInChat, "Set to true to show info when chat is open, false to disable info when chat is open");
        config.save();
        try {
            for (String s : damageColorList.split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.valueOf(ct[0].trim()).intValue(), ct[1]));
            }
        }
        catch (Throwable e) {
            BSLog.warning((String)("Error encountered parsing damageColorList: " + damageColorList), (Object[])new Object[0]);
            BSLog.warning((String)"Reverting to defaultColorList: 100,f; 80,7; 60,e; 40,6; 25,c; 10,4", (Object[])new Object[0]);
            for (String s : DEFAULT_COLOR_LIST.split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.valueOf(ct[0]).intValue(), ct[1]));
            }
        }
        Collections.sort(colorList);
    }

    public static boolean onTickInGame(Minecraft mc) {
        if ((mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P && !mc.field_71474_y.field_74321_H.func_151470_d()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            ArmorStatusHUD.displayArmorStatus(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.toLowerCase().contains("center")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.toLowerCase().contains("right")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.toLowerCase().contains("middle")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    public static boolean playerHasArmorEquipped(EntityPlayer player) {
        return player.field_71071_by.func_70440_f(0) != null || player.field_71071_by.func_70440_f(1) != null || player.field_71071_by.func_70440_f(2) != null || player.field_71071_by.func_70440_f(3) != null;
    }

    public static int countOfDisplayableItems(EntityPlayer player) {
        int i = 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(0)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(1)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(2)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(3)) ? 1 : 0;
        return i += showEquippedItem && ArmorStatusHUD.canDisplayItem(player.func_71045_bC()) ? 1 : 0;
    }

    public static boolean canDisplayItem(ItemStack item) {
        return item != null;
    }

    private static void displayArmorStatus(Minecraft mc) {
        if (ArmorStatusHUD.playerHasArmorEquipped((EntityPlayer)mc.field_71439_g) || showEquippedItem && ArmorStatusHUD.canDisplayItem(mc.field_71439_g.func_71045_bC())) {
            int yOffset = enableItemName ? 18 : 16;
            int yBase = ArmorStatusHUD.getY(ArmorStatusHUD.countOfDisplayableItems((EntityPlayer)mc.field_71439_g), yOffset);
            for (int i = 3; i >= -1; --i) {
                ItemStack itemStack = null;
                itemStack = i == -1 && showEquippedItem ? mc.field_71439_g.func_71045_bC() : (i != -1 ? mc.field_71439_g.field_71071_by.field_70460_b[i] : null);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!ArmorStatusHUD.canDisplayItem(itemStack)) continue;
                int xBase = 0;
                int damage = 1;
                int maxDamage = 1;
                String itemDamage = "";
                if (itemStack.func_77984_f()) {
                    maxDamage = itemStack.func_77958_k() + 1;
                    damage = maxDamage - itemStack.func_77952_i();
                    if (damageDisplayType.equalsIgnoreCase("value")) {
                        itemDamage = "\u00a7" + ColorThreshold.getColorCode(colorList, (int)(damageThresholdType.equalsIgnoreCase("percent") ? damage * 100 / maxDamage : damage)) + damage + (showMaxDamage ? "/" + maxDamage : "");
                    } else if (damageDisplayType.equalsIgnoreCase("percent")) {
                        itemDamage = "\u00a7" + ColorThreshold.getColorCode(colorList, (int)(damageThresholdType.equalsIgnoreCase("percent") ? damage * 100 / maxDamage : damage)) + damage * 100 / maxDamage + "%";
                    }
                }
                xBase = ArmorStatusHUD.getX(22 + mc.field_71466_p.func_78256_a(HUDUtils.stripCtrl((String)itemDamage)));
                String itemName = "";
                if (enableItemName) {
                    itemName = itemStack.func_82833_r();
                    xBase = ArmorStatusHUD.getX(22 + mc.field_71466_p.func_78256_a(itemName));
                }
                GL11.glEnable((int)32826);
                RenderHelper.func_74519_b();
                RenderHelper.func_74520_c();
                ArmorStatusHUD.itemRenderer.field_77023_b = 200.0f;
                if (alignMode.toLowerCase().contains("right")) {
                    xBase = ArmorStatusHUD.getX(0);
                    itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), itemStack, xBase - 18, yBase);
                    if (showItemOverlay) {
                        HUDUtils.renderItemOverlayIntoGUI((FontRenderer)mc.field_71466_p, (ItemStack)itemStack, (int)(xBase - 18), (int)yBase);
                    }
                    RenderHelper.func_74518_a();
                    GL11.glDisable((int)32826);
                    GL11.glDisable((int)3042);
                    int stringWidth = mc.field_71466_p.func_78256_a(HUDUtils.stripCtrl((String)itemName));
                    mc.field_71466_p.func_78261_a(itemName + "\u00a7r", xBase - 20 - stringWidth, yBase, 0xFFFFFF);
                    stringWidth = mc.field_71466_p.func_78256_a(HUDUtils.stripCtrl((String)itemDamage));
                    mc.field_71466_p.func_78261_a(itemDamage + "\u00a7r", xBase - 20 - stringWidth, yBase + (enableItemName ? 9 : 4), 0xFFFFFF);
                } else {
                    itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), itemStack, xBase, yBase);
                    if (showItemOverlay) {
                        HUDUtils.renderItemOverlayIntoGUI((FontRenderer)mc.field_71466_p, (ItemStack)itemStack, (int)xBase, (int)yBase);
                    }
                    RenderHelper.func_74518_a();
                    GL11.glDisable((int)32826);
                    GL11.glDisable((int)3042);
                    mc.field_71466_p.func_78261_a(itemName + "\u00a7r", xBase + 20, yBase, 0xFFFFFF);
                    mc.field_71466_p.func_78261_a(itemDamage + "\u00a7r", xBase + 20, yBase + (enableItemName ? 9 : 4), 0xFFFFFF);
                }
                yBase += yOffset;
            }
        }
    }

    static {
        colorList = new ArrayList<ColorThreshold>();
    }
}

