/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.chunk;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.MaterialDensity;
import ckathode.archimedes.chunk.LocatedBlock;
import ckathode.archimedes.entity.EntityShip;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AssembleResult {
    public static final int RESULT_NONE = 0;
    public static final int RESULT_OK = 1;
    public static final int RESULT_BLOCK_OVERFLOW = 2;
    public static final int RESULT_MISSING_MARKER = 3;
    public static final int RESULT_ERROR_OCCURED = 4;
    public static final int RESULT_BUSY_COMPILING = 5;
    public static final int RESULT_INCONSISTENT = 6;
    public static final int RESULT_OK_WITH_WARNINGS = 7;
    LocatedBlock shipMarkingBlock;
    final List<LocatedBlock> assembledBlocks = new ArrayList<LocatedBlock>();
    int resultCode;
    int blockCount;
    int balloonCount;
    int tileEntityCount;
    float mass;
    public int xOffset;
    public int yOffset;
    public int zOffset;

    public AssembleResult(ByteBuf buf) {
        this.resultCode = buf.readByte();
        if (this.resultCode == 0) {
            return;
        }
        this.blockCount = buf.readInt();
        this.balloonCount = buf.readInt();
        this.tileEntityCount = buf.readInt();
        this.mass = buf.readFloat();
    }

    public AssembleResult(NBTTagCompound compound, World world) {
        this.resultCode = compound.func_74771_c("res");
        this.blockCount = compound.func_74762_e("blockc");
        this.balloonCount = compound.func_74762_e("balloonc");
        this.tileEntityCount = compound.func_74762_e("tec");
        this.mass = compound.func_74760_g("mass");
        this.xOffset = compound.func_74762_e("xO");
        this.yOffset = compound.func_74762_e("yO");
        this.zOffset = compound.func_74762_e("zO");
        if (compound.func_74764_b("list")) {
            NBTTagList list = compound.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound comp = list.func_150305_b(i);
                this.assembledBlocks.add(new LocatedBlock(comp, world));
            }
        }
        if (compound.func_74764_b("marker")) {
            NBTTagCompound comp = compound.func_74775_l("marker");
            this.shipMarkingBlock = new LocatedBlock(comp, world);
        }
    }

    AssembleResult() {
        this.clear();
    }

    void assembleBlock(LocatedBlock lb) {
        this.assembledBlocks.add(lb);
        this.blockCount = this.assembledBlocks.size();
        if (lb.block == ArchimedesShipMod.blockBalloon) {
            ++this.balloonCount;
        }
        if (lb.tileEntity != null) {
            ++this.tileEntityCount;
        }
        this.mass += MaterialDensity.getDensity(lb.block);
        this.xOffset = Math.min(this.xOffset, lb.coords.field_151329_a);
        this.yOffset = Math.min(this.yOffset, lb.coords.field_151327_b);
        this.zOffset = Math.min(this.zOffset, lb.coords.field_151328_c);
    }

    public void clear() {
        this.resultCode = 0;
        this.shipMarkingBlock = null;
        this.assembledBlocks.clear();
        this.tileEntityCount = 0;
        this.balloonCount = 0;
        this.blockCount = 0;
        this.zOffset = 0;
        this.yOffset = 0;
        this.xOffset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityShip getEntity(World world) {
        if (!this.isOK()) {
            return null;
        }
        EntityShip entity = new EntityShip(world);
        entity.setPilotSeat(this.shipMarkingBlock.blockMeta & 3, this.shipMarkingBlock.coords.field_151329_a - this.xOffset, this.shipMarkingBlock.coords.field_151327_b - this.yOffset, this.shipMarkingBlock.coords.field_151328_c - this.zOffset);
        entity.getShipChunk().setCreationSpotBiomeGen(world.func_72807_a(this.shipMarkingBlock.coords.field_151329_a, this.shipMarkingBlock.coords.field_151328_c));
        boolean flag = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        try {
            for (LocatedBlock lb : this.assembledBlocks) {
                int ix = lb.coords.field_151329_a - this.xOffset;
                int iy = lb.coords.field_151327_b - this.yOffset;
                int iz = lb.coords.field_151328_c - this.zOffset;
                TileEntity tileentity = lb.tileEntity;
                if (tileentity != null || lb.block.hasTileEntity(lb.blockMeta) && (tileentity = world.func_147438_o(lb.coords.field_151329_a, lb.coords.field_151327_b, lb.coords.field_151328_c)) != null) {
                    world.func_147475_p(lb.coords.field_151329_a, lb.coords.field_151327_b, lb.coords.field_151328_c);
                    tileentity.func_145829_t();
                    tileentity.func_145836_u();
                    tileentity.field_145854_h = lb.block;
                    tileentity.field_145847_g = lb.blockMeta;
                }
                if (!entity.getShipChunk().setBlockIDWithMetadata(ix, iy, iz, lb.block, lb.blockMeta)) continue;
                entity.getShipChunk().setTileEntity(ix, iy, iz, tileentity);
                world.func_147465_d(lb.coords.field_151329_a, lb.coords.field_151327_b, lb.coords.field_151328_c, Blocks.field_150350_a, 1, 2);
            }
            for (LocatedBlock block : this.assembledBlocks) {
                world.func_147468_f(block.coords.field_151329_a, block.coords.field_151327_b, block.coords.field_151328_c);
            }
        }
        catch (Exception e) {
            this.resultCode = 4;
            e.printStackTrace();
            EntityShip entityShip = null;
            return entityShip;
        }
        finally {
            world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flag));
        }
        entity.getShipChunk().setChunkModified();
        entity.getShipChunk().onChunkLoad();
        entity.func_70012_b((float)this.xOffset + entity.getShipChunk().getCenterX(), this.yOffset, (float)this.zOffset + entity.getShipChunk().getCenterZ(), 0.0f, 0.0f);
        return entity;
    }

    public int getCode() {
        return this.resultCode;
    }

    public boolean isOK() {
        return this.resultCode == 1 || this.resultCode == 7;
    }

    public LocatedBlock getShipMarker() {
        return this.shipMarkingBlock;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getBalloonCount() {
        return this.balloonCount;
    }

    public int getTileEntityCount() {
        return this.tileEntityCount;
    }

    public float getMass() {
        return this.mass;
    }

    public void checkConsistent(World world) {
        boolean warn = false;
        for (LocatedBlock lb : this.assembledBlocks) {
            Block block = world.func_147439_a(lb.coords.field_151329_a, lb.coords.field_151327_b, lb.coords.field_151328_c);
            if (block != lb.block) {
                this.resultCode = 6;
                return;
            }
            int meta = world.func_72805_g(lb.coords.field_151329_a, lb.coords.field_151327_b, lb.coords.field_151328_c);
            if (meta == lb.blockMeta) continue;
            warn = true;
        }
        this.resultCode = warn ? 7 : 1;
    }

    public void writeNBTFully(NBTTagCompound compound) {
        this.writeNBTMetadata(compound);
        NBTTagList list = new NBTTagList();
        for (LocatedBlock lb : this.assembledBlocks) {
            NBTTagCompound comp = new NBTTagCompound();
            lb.writeToNBT(comp);
            list.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("list", (NBTBase)list);
        if (this.shipMarkingBlock != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.shipMarkingBlock.writeToNBT(comp);
            compound.func_74782_a("marker", (NBTBase)comp);
        }
    }

    public void writeNBTMetadata(NBTTagCompound compound) {
        compound.func_74774_a("res", (byte)this.getCode());
        compound.func_74768_a("blockc", this.getBlockCount());
        compound.func_74768_a("balloonc", this.getBalloonCount());
        compound.func_74768_a("tec", this.getTileEntityCount());
        compound.func_74776_a("mass", this.getMass());
        compound.func_74768_a("xO", this.xOffset);
        compound.func_74768_a("yO", this.yOffset);
        compound.func_74768_a("zO", this.zOffset);
    }
}

