/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.entity;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.MaterialDensity;
import ckathode.archimedes.blockitem.TileEntityEngine;
import ckathode.archimedes.entity.EntityEntityAttachment;
import ckathode.archimedes.entity.EntitySeat;
import ckathode.archimedes.entity.EntityShip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public final class ShipCapabilities {
    private final EntityShip ship;
    public float speedMultiplier;
    public float rotationMultiplier;
    public float liftMultiplier;
    public float brakeMult;
    private int balloons;
    private int floaters;
    private int blockCount;
    private float mass;
    private List<EntityEntityAttachment> seats;
    private List<TileEntityEngine> engines;
    private float enginePower;

    ShipCapabilities(EntityShip entityship) {
        this.ship = entityship;
        this.clear();
    }

    public float getPoweredSpeedMult() {
        return this.speedMultiplier + this.enginePower * 0.5f;
    }

    public float getPoweredRotationMult() {
        return this.rotationMultiplier + this.enginePower * 0.25f;
    }

    public float getPoweredLiftMult() {
        return this.liftMultiplier + this.enginePower * 0.5f;
    }

    public float getEnginePower() {
        return this.enginePower;
    }

    public void updateEngines() {
        this.enginePower = 0.0f;
        if (this.engines != null) {
            for (TileEntityEngine te : this.engines) {
                te.updateRunning();
                if (!te.isRunning()) continue;
                this.enginePower += te.enginePower;
            }
        }
    }

    public boolean canFly() {
        return ArchimedesShipMod.instance.modConfig.enableAirShips && (float)this.balloons >= (float)this.blockCount * ArchimedesShipMod.instance.modConfig.flyBalloonRatio;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getBalloonCount() {
        return this.balloons;
    }

    public int getFloaterCount() {
        return this.floaters;
    }

    public float getMass() {
        return this.mass;
    }

    public void addAttachments(EntityEntityAttachment entity) {
        if (this.seats == null) {
            this.seats = new ArrayList<EntityEntityAttachment>(4);
        }
        this.seats.add(entity);
    }

    public List<EntityEntityAttachment> getAttachments() {
        return this.seats;
    }

    public List<TileEntityEngine> getEngines() {
        return this.engines;
    }

    protected void onChunkBlockAdded(Block block, int metadata, int x, int y, int z) {
        ++this.blockCount;
        this.mass += MaterialDensity.getDensity(block);
        if (block == ArchimedesShipMod.blockBalloon) {
            ++this.balloons;
        } else if (block == ArchimedesShipMod.blockFloater) {
            ++this.floaters;
        } else if (block == ArchimedesShipMod.blockEngine) {
            TileEntity te = this.ship.getShipChunk().func_147438_o(x, y, z);
            if (te instanceof TileEntityEngine) {
                if (this.engines == null) {
                    this.engines = new ArrayList<TileEntityEngine>(4);
                }
                this.engines.add((TileEntityEngine)te);
            }
        } else if (block == ArchimedesShipMod.blockSeat && !this.ship.field_70170_p.field_72995_K) {
            int x1 = this.ship.seatX;
            int y1 = this.ship.seatY;
            int z1 = this.ship.seatZ;
            if (this.ship.frontDirection == 0) {
                --z1;
            } else if (this.ship.frontDirection == 1) {
                ++x1;
            } else if (this.ship.frontDirection == 2) {
                ++z1;
            } else if (this.ship.frontDirection == 3) {
                --x1;
            }
            if (x != x1 || y != y1 || z != z1) {
                EntitySeat seat = new EntitySeat(this.ship.field_70170_p);
                seat.setParentShip(this.ship, x, y, z);
                this.addAttachments(seat);
            }
        }
    }

    public boolean mountEntity(Entity entity) {
        if (this.seats == null) {
            return false;
        }
        for (EntityEntityAttachment seat : this.seats) {
            if (seat.field_70153_n == null) {
                entity.func_70078_a((Entity)seat);
                return true;
            }
            if (seat.field_70153_n != entity) continue;
            seat.func_70078_a(null);
            return true;
        }
        return false;
    }

    public void spawnSeatEntities() {
        if (this.seats != null) {
            for (EntityEntityAttachment seat : this.seats) {
                this.ship.field_70170_p.func_72838_d((Entity)seat);
            }
        }
    }

    public void clearBlockCount() {
        this.liftMultiplier = 1.0f;
        this.rotationMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.brakeMult = 0.9f;
        this.balloons = 0;
        this.floaters = 0;
        this.blockCount = 0;
        this.mass = 0.0f;
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
    }

    public void clear() {
        if (this.seats != null) {
            for (EntityEntityAttachment seat : this.seats) {
                seat.func_70106_y();
            }
            this.seats = null;
        }
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
        this.clearBlockCount();
    }
}

