/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import hunternif.mc.atlas.AntiqueAtlasMod;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class FileUtil {
    private static final JsonParser parser = new JsonParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonElement readJson(File file) {
        JsonElement root = null;
        InputStream input = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
                JsonElement jsonElement = null;
                return jsonElement;
            }
            input = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(input);
            root = parser.parse((Reader)reader);
        }
        catch (Exception e) {
            AntiqueAtlasMod.logger.error("Error reading file \"" + file.getName() + "\": " + e.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJson(JsonElement root, File file) {
        BufferedWriter writer = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new FileWriter(file));
            gson.toJson(root, (Appendable)writer);
        }
        catch (Exception e) {
            AntiqueAtlasMod.logger.error("Error writing file \"" + file.getName() + "\": " + e.toString());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

