/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.util;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.util.ShortVec2;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class ExportImageUtil {
    public static final int TILE_SIZE = 16;
    public static final int BG_TILE_SIZE = 22;

    public static File selectPngFileToSave(String atlasName, ExportUpdateListener listener) {
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.opening", (Object[])new Object[0]));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            AntiqueAtlasMod.logger.warn("Setting system Look&Feel for JFileChooser", (Throwable)e);
        }
        Frame frame = new Frame();
        frame.setUndecorated(true);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        frame.toFront();
        frame.setVisible(false);
        frame.dispose();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        chooser.setSelectedFile(new File(atlasName + ".png"));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PNG Image";
            }

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.selectFile", (Object[])new Object[0]));
        if (chooser.showSaveDialog(frame) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getName().substring(file.getName().length() - 4).equalsIgnoreCase(".png")) {
                file = new File(file.getAbsolutePath() + ".png");
            }
            return file;
        }
        return null;
    }

    public static void exportPngImage(DimensionData data, File file, ExportUpdateListener listener) {
        int y;
        int x;
        Map<ShortVec2, MapTile> tiles = data.getSeenChunks();
        int totalTiles = tiles.size();
        int drawnTiles = 0;
        int minX = (data.getMinX() - 1) * 16;
        int minY = (data.getMinY() - 1) * 16;
        int outWidth = (data.getMaxX() + 2) * 16 - minX;
        int outHeight = (data.getMaxY() + 2) * 16 - minY;
        AntiqueAtlasMod.logger.info("Image size: " + outWidth + "*" + outHeight);
        BufferedImage outImage = new BufferedImage(outWidth, outHeight, 2);
        Graphics2D graphics = outImage.createGraphics();
        int scale = 2;
        int bgTilesX = Math.round((float)outWidth / 22.0f / (float)scale);
        int bgTilesY = Math.round((float)outHeight / 22.0f / (float)scale);
        totalTiles += (bgTilesX + 1) * (bgTilesY + 1);
        listener.setStatusString("Loading textures...");
        BufferedImage bg = null;
        HashMap<ResourceLocation, BufferedImage> textureImageMap = new HashMap<ResourceLocation, BufferedImage>();
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(Textures.EXPORTED_BG).func_110527_b();
            bg = ImageIO.read(is);
            is.close();
            List<ResourceLocation> allTextures = BiomeTextureMap.INSTANCE.getAllTextures();
            totalTiles += allTextures.size();
            for (ResourceLocation texture : allTextures) {
                is = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b();
                BufferedImage tileImage = ImageIO.read(is);
                is.close();
                textureImageMap.put(texture, tileImage);
                ++drawnTiles;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        listener.update((float)drawnTiles / (float)totalTiles);
        listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.rendering", (Object[])new Object[0]));
        graphics.drawImage(bg, 0, 0, 22 * scale, 22 * scale, 0, 0, 22, 22, null);
        ++drawnTiles;
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, 0, (x + 1) * 22 * scale, 22 * scale, 22, 0, 44, 22, null);
            ++drawnTiles;
        }
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, 0, y * 22 * scale, 22 * scale, (y + 1) * 22 * scale, 0, 22, 22, 44, null);
            ++drawnTiles;
        }
        listener.update((float)drawnTiles / (float)totalTiles);
        for (x = 1; x < bgTilesX; ++x) {
            for (int y2 = 1; y2 < bgTilesY; ++y2) {
                graphics.drawImage(bg, x * 22 * scale, y2 * 22 * scale, (x + 1) * 22 * scale, (y2 + 1) * 22 * scale, 22, 22, 44, 44, null);
                ++drawnTiles;
            }
        }
        listener.update((float)drawnTiles / (float)totalTiles);
        graphics.drawImage(bg, outWidth - 22 * scale, 0, outWidth, 22 * scale, 44, 0, 66, 22, null);
        ++drawnTiles;
        for (y = 1; y < bgTilesY; ++y) {
            graphics.drawImage(bg, outWidth - 22 * scale, y * 22 * scale, outWidth, (y + 1) * 22 * scale, 44, 22, 66, 44, null);
            ++drawnTiles;
        }
        graphics.drawImage(bg, 0, outHeight - 22 * scale, 22 * scale, outHeight, 0, 44, 22, 66, null);
        ++drawnTiles;
        for (x = 1; x < bgTilesX; ++x) {
            graphics.drawImage(bg, x * 22 * scale, outHeight - 22 * scale, (x + 1) * 22 * scale, outHeight, 22, 44, 44, 66, null);
            ++drawnTiles;
        }
        graphics.drawImage(bg, outWidth - 22 * scale, outHeight - 22 * scale, outWidth, outHeight, 44, 44, 66, 66, null);
        listener.update((float)(++drawnTiles) / (float)totalTiles);
        ShortVec2 coords = new ShortVec2(0, 0);
        coords.x = data.getMinX();
        while (coords.x <= data.getMaxX()) {
            coords.y = data.getMinY();
            while (coords.y <= data.getMaxY()) {
                ResourceLocation texture;
                BufferedImage tileImage;
                MapTile tile = tiles.get(coords);
                if (tile != null && (tileImage = (BufferedImage)textureImageMap.get(texture = BiomeTextureMap.instance().getTexture(tile))) != null) {
                    if (tile.isSingleObject()) {
                        graphics.drawImage(tileImage, coords.x * 16 - minX, coords.y * 16 - minY, (coords.x + 1) * 16 - minX, (coords.y + 1) * 16 - minY, 0, 0, 16, 16, null);
                    } else {
                        int u = 0;
                        int v = 0;
                        if (tile.topLeft == 1) {
                            u = 2;
                            v = 0;
                        } else if (tile.topLeft == 3) {
                            u = 0;
                            v = 4;
                        } else if (tile.topLeft == 2) {
                            u = 2;
                            v = 2;
                        } else if (tile.topLeft == 4) {
                            u = 2;
                            v = 4;
                        } else if (tile.topLeft == 0) {
                            u = 0;
                            v = 2;
                        }
                        graphics.drawImage(tileImage, coords.x * 16 - minX, coords.y * 16 - minY, coords.x * 16 + 8 - minX, coords.y * 16 + 8 - minY, u * 16 / 2, v * 16 / 2, (u + 1) * 16 / 2, (v + 1) * 16 / 2, null);
                        if (tile.topRight == 1) {
                            u = 3;
                            v = 0;
                        } else if (tile.topRight == 3) {
                            u = 3;
                            v = 4;
                        } else if (tile.topRight == 2) {
                            u = 1;
                            v = 2;
                        } else if (tile.topRight == 4) {
                            u = 1;
                            v = 4;
                        } else if (tile.topRight == 0) {
                            u = 3;
                            v = 2;
                        }
                        graphics.drawImage(tileImage, coords.x * 16 + 8 - minX, coords.y * 16 - minY, coords.x * 16 + 16 - minX, coords.y * 16 + 8 - minY, u * 16 / 2, v * 16 / 2, (u + 1) * 16 / 2, (v + 1) * 16 / 2, null);
                        if (tile.bottomLeft == 1) {
                            u = 2;
                            v = 1;
                        } else if (tile.bottomLeft == 3) {
                            u = 0;
                            v = 3;
                        } else if (tile.bottomLeft == 2) {
                            u = 2;
                            v = 5;
                        } else if (tile.bottomLeft == 4) {
                            u = 2;
                            v = 3;
                        } else if (tile.bottomLeft == 0) {
                            u = 0;
                            v = 5;
                        }
                        graphics.drawImage(tileImage, coords.x * 16 - minX, coords.y * 16 + 8 - minY, coords.x * 16 + 8 - minX, coords.y * 16 + 16 - minY, u * 16 / 2, v * 16 / 2, (u + 1) * 16 / 2, (v + 1) * 16 / 2, null);
                        if (tile.bottomRight == 1) {
                            u = 3;
                            v = 1;
                        } else if (tile.bottomRight == 3) {
                            u = 3;
                            v = 3;
                        } else if (tile.bottomRight == 2) {
                            u = 1;
                            v = 5;
                        } else if (tile.bottomRight == 4) {
                            u = 1;
                            v = 3;
                        } else if (tile.bottomRight == 0) {
                            u = 3;
                            v = 5;
                        }
                        graphics.drawImage(tileImage, coords.x * 16 + 8 - minX, coords.y * 16 + 8 - minY, coords.x * 16 + 16 - minX, coords.y * 16 + 16 - minY, u * 16 / 2, v * 16 / 2, (u + 1) * 16 / 2, (v + 1) * 16 / 2, null);
                        if (++drawnTiles % 10 == 0) {
                            listener.update((float)drawnTiles / (float)totalTiles);
                        }
                    }
                }
                coords.y = (short)(coords.y + 1);
            }
            coords.x = (short)(coords.x + 1);
        }
        try {
            listener.setStatusString(I18n.func_135052_a((String)"gui.antiqueatlas.export.writing", (Object[])new Object[0]));
            ImageIO.write((RenderedImage)outImage, "PNG", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

