/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.ModPacket;
import hunternif.mc.atlas.util.ZipUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketPipeline
extends MessageToMessageCodec<FMLProxyPacket, ModPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends ModPacket>> packets = new LinkedList();
    private boolean isPostInitialized = false;

    public boolean registerPacket(Class<? extends ModPacket> clazz) {
        if (this.packets.size() > 256) {
            AntiqueAtlasMod.logger.error("Too many packets registered");
            return false;
        }
        if (this.packets.contains(clazz)) {
            AntiqueAtlasMod.logger.warn("Packet already registered: " + clazz.getName());
            return false;
        }
        if (this.isPostInitialized) {
            AntiqueAtlasMod.logger.error("Attempted to register packet in post-init");
            return false;
        }
        this.packets.add(clazz);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, ModPacket msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        if (!this.packets.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(clazz);
        buffer.writeByte((int)discriminator);
        if (msg.isCompressed()) {
            ByteBuf tempBuf = Unpooled.buffer();
            msg.encodeInto(ctx, tempBuf);
            byte[] data = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(data);
            byte[] zipData = ZipUtil.compressByteArray(data);
            buffer.writeBytes(zipData);
        } else {
            msg.encodeInto(ctx, buffer);
        }
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends ModPacket> clazz = this.packets.get(discriminator);
        if (clazz == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        ModPacket pkt = clazz.newInstance();
        if (pkt.isCompressed()) {
            ByteBuf tempBuf = payload.slice();
            byte[] zipData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(zipData);
            tempBuf = Unpooled.wrappedBuffer((byte[])ZipUtil.decompressByteArray(zipData));
            pkt.decodeInto(ctx, tempBuf);
        } else {
            pkt.decodeInto(ctx, payload.slice());
        }
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                pkt.handleClientSide(player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayer player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                pkt.handleServerSide(player);
                break;
            }
        }
        out.add(pkt);
    }

    public void initialize() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("antiqueatlas", new ChannelHandler[]{this});
    }

    public void postInitialize() {
        if (this.isPostInitialized) {
            return;
        }
        this.isPostInitialized = true;
        Collections.sort(this.packets, new Comparator<Class<? extends ModPacket>>(){

            @Override
            public int compare(Class<? extends ModPacket> clazz1, Class<? extends ModPacket> clazz2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(clazz1.getCanonicalName(), clazz2.getCanonicalName());
                if (com == 0) {
                    com = clazz1.getCanonicalName().compareTo(clazz2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(ModPacket packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendTo(ModPacket packet, EntityPlayer player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(ModPacket packet, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToDimension(ModPacket packet, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToServer(ModPacket packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendToWorld(ModPacket packet, World world) {
        if (world.field_72995_K) {
            return;
        }
        for (Object playerObj : world.field_73010_i) {
            this.sendTo(packet, (EntityPlayer)playerObj);
        }
    }
}

