/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.network.ModPacket;
import hunternif.mc.atlas.util.ShortVec2;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class MapDataPacket
extends ModPacket {
    public static final int ENTRY_SIZE_BYTES = 6;
    private int atlasID;
    private int dimension;
    private Map<ShortVec2, MapTile> data;

    public MapDataPacket() {
        this.data = new HashMap<ShortVec2, MapTile>();
    }

    public MapDataPacket(int atlasID, int dimension, Map<ShortVec2, MapTile> data) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.data = data;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeShort(this.atlasID);
        buffer.writeShort(this.dimension);
        buffer.writeShort(this.data.size());
        for (Map.Entry<ShortVec2, MapTile> entry : this.data.entrySet()) {
            buffer.writeShort((int)entry.getKey().x);
            buffer.writeShort((int)entry.getKey().y);
            buffer.writeShort(entry.getValue().biomeID);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.atlasID = buffer.readShort();
        this.dimension = buffer.readShort();
        int length = buffer.readShort();
        for (int i = 0; i < length; ++i) {
            ShortVec2 coords = new ShortVec2(buffer.readShort(), buffer.readShort());
            short biomeID = buffer.readShort();
            MapTile tile = new MapTile(biomeID);
            tile.randomizeTexture();
            this.data.put(coords, tile);
        }
    }

    @Override
    protected boolean isCompressed() {
        return true;
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        AtlasData atlasData = AntiqueAtlasMod.itemAtlas.getClientAtlasData(this.atlasID);
        for (Map.Entry<ShortVec2, MapTile> entry : this.data.entrySet()) {
            atlasData.putTile(this.dimension, entry.getKey(), entry.getValue());
        }
    }
}

