/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import hunternif.mc.atlas.network.GlobalMarkersPacket;
import hunternif.mc.atlas.network.MapDataPacket;
import hunternif.mc.atlas.network.MarkersPacket;
import hunternif.mc.atlas.network.TileNameIDPacket;
import hunternif.mc.atlas.network.TilesPacket;
import hunternif.mc.atlas.util.ZipUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;

public abstract class CustomPacket {
    public static final int MAX_SIZE_BYTES = 32000;
    private static final BiMap<Integer, Class<? extends CustomPacket>> idMap;

    public static CustomPacket constructPacket(int packetId) throws ProtocolException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)idMap.get((Object)packetId);
        if (clazz == null) {
            throw new ProtocolException("Unknown Packet Id!");
        }
        return (CustomPacket)clazz.newInstance();
    }

    public final int getPacketId() {
        if (idMap.inverse().containsKey(this.getClass())) {
            return (Integer)idMap.inverse().get(this.getClass());
        }
        throw new RuntimeException("Packet " + this.getClass().getSimpleName() + " is missing a mapping!");
    }

    public final Packet makePacket() {
        ByteArrayDataOutput dataOut = ByteStreams.newDataOutput();
        this.write(dataOut);
        byte[] data = dataOut.toByteArray();
        if (this.isCompressed()) {
            data = ZipUtil.compressByteArray(data);
        }
        ByteArrayDataOutput packetOut = ByteStreams.newDataOutput();
        packetOut.writeByte(this.getPacketId());
        packetOut.write(data);
        return PacketDispatcher.getPacket((String)"antiqueatlas", (byte[])packetOut.toByteArray());
    }

    protected boolean isCompressed() {
        return false;
    }

    public abstract PacketDirection getPacketDirection();

    public abstract void write(ByteArrayDataOutput var1);

    public abstract void read(ByteArrayDataInput var1) throws ProtocolException;

    public abstract void execute(EntityPlayer var1, Side var2) throws ProtocolException;

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)0, MapDataPacket.class);
        builder.put((Object)1, TilesPacket.class);
        builder.put((Object)2, TileNameIDPacket.class);
        builder.put((Object)3, MarkersPacket.class);
        builder.put((Object)4, GlobalMarkersPacket.class);
        idMap = builder.build();
    }

    protected static enum PacketDirection {
        CLIENT_TO_SERVER(false, true),
        SERVER_TO_CLIENT(true, false),
        BOTH(true, true);

        public final boolean toClient;
        public final boolean toServer;

        private PacketDirection(boolean toClient, boolean toServer) {
            this.toClient = toClient;
            this.toServer = toServer;
        }
    }

    public static class ProtocolException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ProtocolException() {
        }

        public ProtocolException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProtocolException(String message) {
            super(message);
        }

        public ProtocolException(Throwable cause) {
            super(cause);
        }
    }
}

