/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.network.MarkersPacket;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class MarkersData
extends WorldSavedData {
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_MARKER_TYPE = "markerType";
    private static final String TAG_MARKER_LABEL = "label";
    private static final String TAG_MARKER_X = "x";
    private static final String TAG_MARKER_Y = "y";
    private static final Supplier<SortedSet<Marker>> concurrentSortedSetSupplier = new Supplier<SortedSet<Marker>>(){

        public SortedSet<Marker> get() {
            return new ConcurrentSkipListSet<Marker>();
        }
    };
    private final Set<EntityPlayer> playersSentTo = new HashSet<EntityPlayer>();
    private final Map<Integer, SortedSetMultimap<ShortVec2, Marker>> dimensionMap = new ConcurrentHashMap<Integer, SortedSetMultimap<ShortVec2, Marker>>();

    public MarkersData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound tag = dimensionMapList.func_150305_b(d);
            int dimensionID = tag.func_74762_e(TAG_DIMENSION_ID);
            SortedSetMultimap<ShortVec2, Marker> markers = this.getMarkersInDimension(dimensionID);
            NBTTagList tagList = tag.func_150295_c(TAG_MARKERS, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound markerTag = tagList.func_150305_b(i);
                Marker marker = new Marker(markerTag.func_74779_i(TAG_MARKER_TYPE), markerTag.func_74779_i(TAG_MARKER_LABEL), markerTag.func_74762_e(TAG_MARKER_X), markerTag.func_74762_e(TAG_MARKER_Y));
                markers.put((Object)marker.getChunkCoords(), (Object)marker);
            }
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList dimensionMapList = new NBTTagList();
        for (Integer dimension : this.dimensionMap.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_DIMENSION_ID, dimension.intValue());
            SortedSetMultimap<ShortVec2, Marker> markers = this.getMarkersInDimension(dimension);
            NBTTagList tagList = new NBTTagList();
            for (Marker marker : markers.values()) {
                NBTTagCompound markerTag = new NBTTagCompound();
                markerTag.func_74778_a(TAG_MARKER_TYPE, marker.getType());
                markerTag.func_74778_a(TAG_MARKER_LABEL, marker.getLabel());
                markerTag.func_74768_a(TAG_MARKER_X, marker.getX());
                markerTag.func_74768_a(TAG_MARKER_Y, marker.getY());
                tagList.func_74742_a((NBTBase)markerTag);
            }
            tag.func_74782_a(TAG_MARKERS, (NBTBase)tagList);
            dimensionMapList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
    }

    private SortedSetMultimap<ShortVec2, Marker> getMarkersInDimension(int dimension) {
        SortedSetMultimap map = this.dimensionMap.get(dimension);
        if (map == null) {
            map = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)Multimaps.newSortedSetMultimap(new ConcurrentHashMap(), concurrentSortedSetSupplier));
            this.dimensionMap.put(dimension, (SortedSetMultimap<ShortVec2, Marker>)map);
        }
        return map;
    }

    public SortedSet<Marker> getMarkersAtChunk(int dimension, ShortVec2 coords) {
        return this.getMarkersInDimension(dimension).get((Object)coords);
    }

    public void putMarker(int dimension, Marker marker) {
        this.getMarkersInDimension(dimension).put((Object)marker.getChunkCoords(), (Object)marker);
    }

    public boolean isSyncedOnPlayer(EntityPlayer player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        int pieces = 0;
        int dataSizeBytes = 0;
        for (Integer dimension : this.dimensionMap.keySet()) {
            MarkersPacket packet = this.newMarkersPacket(atlasID, dimension);
            SortedSetMultimap<ShortVec2, Marker> markers = this.getMarkersInDimension(dimension);
            for (Marker marker : markers.values()) {
                packet.putMarker(marker);
                if ((dataSizeBytes += 8 + (marker.getLabel().length() + marker.getType().length()) * 2) < 32000) continue;
                AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
                ++pieces;
                dataSizeBytes = 0;
                packet = this.newMarkersPacket(atlasID, dimension);
            }
            if (packet.isEmpty()) continue;
            AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
            ++pieces;
            dataSizeBytes = 0;
        }
        AntiqueAtlasMod.logger.info("Sent markers data to player " + player.func_70005_c_() + " in " + pieces + " pieces.");
        this.playersSentTo.add(player);
    }

    protected MarkersPacket newMarkersPacket(int atlasID, int dimension) {
        return new MarkersPacket(atlasID, dimension, new Marker[0]);
    }

    public boolean isEmpty() {
        return this.dimensionMap.isEmpty();
    }
}

