/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.util.FileUtil;
import java.io.File;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class MarkerTextureConfig {
    private final File file;

    public MarkerTextureConfig(File file) {
        this.file = file;
    }

    public void load() {
        JsonElement root = FileUtil.readJson(this.file);
        if (root == null) {
            AntiqueAtlasMod.logger.info("Marker textures config not found");
            return;
        }
        if (!root.isJsonObject()) {
            AntiqueAtlasMod.logger.error("Malformed marker textures config");
            return;
        }
        for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
            String markerType = (String)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) {
                AntiqueAtlasMod.logger.error("Malformed marker textures config entry: " + markerType);
                break;
            }
            ResourceLocation texture = new ResourceLocation(((JsonElement)entry.getValue()).getAsString());
            MarkerTextureMap.instance().setTexture(markerType, texture);
        }
    }

    public void save() {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, ResourceLocation> entry : MarkerTextureMap.instance().getMap().entrySet()) {
            root.addProperty(entry.getKey(), entry.getValue().toString());
        }
        FileUtil.writeJson((JsonElement)root, this.file);
    }
}

