/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.util.ShortVec2;

public class Marker
implements Comparable<Marker> {
    private final String type;
    private final String label;
    private final int x;
    private final int y;

    public Marker(String type, String label, int x, int y) {
        this.type = type;
        this.label = label == null ? "" : label;
        this.x = x;
        this.y = y;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getInChunkX() {
        return this.x & 0xF;
    }

    public int getInChunkY() {
        return this.y & 0xF;
    }

    @Override
    public int compareTo(Marker marker) {
        return this.y - marker.y;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)obj;
        return this.type.equals(marker.type) && this.label.equals(marker.label) && this.x == marker.x && this.y == marker.y;
    }

    public ShortVec2 getChunkCoords() {
        return new ShortVec2(this.x >> 4, this.y >> 4);
    }

    public String toString() {
        return "\"" + this.label + "\"" + "@(" + this.x + ", " + this.y + ")";
    }
}

