/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import hunternif.mc.atlas.api.AtlasAPI;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class VillageWatcher {
    private final Set<Village> visited = new HashSet<Village>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            this.visitAllUnvisitedVillages(event.world);
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        if (!event.world.field_72995_K) {
            this.visitAllUnvisitedVillages(event.world);
        }
    }

    public void visitAllUnvisitedVillages(World world) {
        VillageCollection villageCollection = world.field_72982_D;
        if (villageCollection == null) {
            return;
        }
        for (Village village : villageCollection.func_75540_b()) {
            if (this.visited.contains(village)) continue;
            this.visitVillage(world, village);
        }
    }

    public void visitVillage(World world, Village village) {
        for (int dx = -village.func_75568_b(); dx <= village.func_75568_b(); dx += 16) {
            for (int dz = -village.func_75568_b(); dz <= village.func_75568_b(); dz += 16) {
                if (dx * dx + dz * dz > village.func_75568_b() * village.func_75568_b()) continue;
                AtlasAPI.getTileAPI().putCustomTile(world, 0, "npcVillageTerritory", village.func_75577_a().field_71574_a + dx >> 4, village.func_75577_a().field_71573_c + dz >> 4);
            }
        }
        for (Object doorInfo : village.func_75558_f()) {
            VillageDoorInfo door = (VillageDoorInfo)doorInfo;
            AtlasAPI.getTileAPI().putCustomTile(world, 0, "npcVillageDoor", door.field_75481_a >> 4, door.field_75480_c >> 4);
            this.visited.add(village);
        }
    }
}

