/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.TileNameIDPacket;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public enum ExtTileIdMap {
    INSTANCE;

    public static final String TILE_VILLAGE_HOUSE = "npcVillageDoor";
    public static final String TILE_VILLAGE_TERRITORY = "npcVillageTerritory";
    private int lastID = -1;
    private final BiMap<String, Integer> nameToIdMap = HashBiMap.create();

    public static ExtTileIdMap instance() {
        return INSTANCE;
    }

    public int getOrCreatePseudoBiomeID(String uniqueName) {
        Integer id = (Integer)this.nameToIdMap.get((Object)uniqueName);
        if (id == null) {
            id = this.findNewID();
            this.nameToIdMap.put((Object)uniqueName, (Object)id);
            AntiqueAtlasMod.proxy.updateExtTileConfig();
        }
        return id;
    }

    public int getPseudoBiomeID(String uniqueName) {
        Integer id = (Integer)this.nameToIdMap.get((Object)uniqueName);
        return id == null ? -1 : id;
    }

    private int findNewID() {
        while (this.lastID > Short.MIN_VALUE && this.nameToIdMap.inverse().containsKey((Object)(--this.lastID))) {
        }
        return this.lastID;
    }

    public void setPseudoBiomeID(String uniqueName, int id) {
        this.nameToIdMap.put((Object)uniqueName, (Object)id);
    }

    Map<String, Integer> getMap() {
        return this.nameToIdMap;
    }

    public void syncOnPlayer(EntityPlayer player) {
        AntiqueAtlasMod.packetPipeline.sendTo(new TileNameIDPacket((Map<String, Integer>)this.nameToIdMap), player);
    }
}

