/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.FileUtil;
import java.io.File;
import java.util.Map;

public class ExtTileConfig {
    private final File file;

    public ExtTileConfig(File file) {
        this.file = file;
    }

    public void load() {
        JsonElement root = FileUtil.readJson(this.file);
        if (root == null) {
            AntiqueAtlasMod.logger.info("tileIDs config not found");
            return;
        }
        if (!root.isJsonObject()) {
            AntiqueAtlasMod.logger.error("Malformed tileIDs config");
            return;
        }
        for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
            String name = (String)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) {
                AntiqueAtlasMod.logger.error("Malformed tileIDs config entry: " + name);
                break;
            }
            try {
                int id = ((JsonElement)entry.getValue()).getAsInt();
                ExtTileIdMap.instance().setPseudoBiomeID(name, id);
            }
            catch (NumberFormatException e) {
                AntiqueAtlasMod.logger.error("Malformed tileIDs config entry: " + name);
                break;
            }
        }
    }

    public void save() {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, Integer> entry : ExtTileIdMap.instance().getMap().entrySet()) {
            root.addProperty(entry.getKey(), (Number)entry.getValue());
        }
        FileUtil.writeJson((JsonElement)root, this.file);
    }
}

