/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.TilesPacket;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class ExtBiomeData
extends WorldSavedData {
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_BIOME_IDS = "biomeIDs";
    private final Map<Integer, Map<ShortVec2, Integer>> dimensionMap = new ConcurrentHashMap<Integer, Map<ShortVec2, Integer>>();

    public ExtBiomeData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound tag = dimensionMapList.func_150305_b(d);
            int dimensionID = tag.func_74762_e(TAG_DIMENSION_ID);
            Map<ShortVec2, Integer> biomeMap = this.getBiomesInDimension(dimensionID);
            int[] intArray = tag.func_74759_k(TAG_BIOME_IDS);
            for (int i = 0; i < intArray.length; i += 3) {
                ShortVec2 coords = new ShortVec2(intArray[i], intArray[i + 1]);
                biomeMap.put(coords, intArray[i + 2]);
            }
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList dimensionMapList = new NBTTagList();
        for (Integer dimension : this.dimensionMap.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_DIMENSION_ID, dimension.intValue());
            Map<ShortVec2, Integer> biomeMap = this.getBiomesInDimension(dimension);
            int[] intArray = new int[biomeMap.size() * 3];
            int i = 0;
            for (Map.Entry<ShortVec2, Integer> entry : biomeMap.entrySet()) {
                intArray[i++] = entry.getKey().x;
                intArray[i++] = entry.getKey().y;
                intArray[i++] = entry.getValue();
            }
            tag.func_74783_a(TAG_BIOME_IDS, intArray);
            dimensionMapList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
    }

    private Map<ShortVec2, Integer> getBiomesInDimension(int dimension) {
        Map<ShortVec2, Integer> map = this.dimensionMap.get(dimension);
        if (map == null) {
            map = new ConcurrentHashMap<ShortVec2, Integer>();
            this.dimensionMap.put(dimension, map);
        }
        return map;
    }

    public int getBiomeIdAt(int dimension, ShortVec2 coords) {
        Integer biomeID = this.getBiomesInDimension(dimension).get(coords);
        return biomeID == null ? -1 : biomeID;
    }

    public void setBiomeIdAt(int dimension, int biomeID, ShortVec2 coords) {
        this.getBiomesInDimension(dimension).put(coords, biomeID);
    }

    public void syncOnPlayer(EntityPlayer player) {
        int pieces = 0;
        int dataSizeBytes = 0;
        for (Integer dimension : this.dimensionMap.keySet()) {
            TilesPacket packet = new TilesPacket(dimension);
            Map<ShortVec2, Integer> biomes = this.getBiomesInDimension(dimension);
            for (Map.Entry<ShortVec2, Integer> entry : biomes.entrySet()) {
                packet.addTile(entry.getKey(), entry.getValue());
                if ((dataSizeBytes += 6) < 32000) continue;
                AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
                ++pieces;
                dataSizeBytes = 0;
                packet = new TilesPacket(dimension);
            }
            if (packet.isEmpty()) continue;
            AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
            ++pieces;
            dataSizeBytes = 0;
        }
        AntiqueAtlasMod.logger.info("Sent custom biome data to player " + player.func_70005_c_() + " in " + pieces + " pieces.");
    }
}

