/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.StandardTextureSet;
import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.util.FileUtil;
import java.io.File;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class BiomeTextureConfig {
    private final File file;

    public BiomeTextureConfig(File file) {
        this.file = file;
    }

    public void load() {
        JsonElement root = FileUtil.readJson(this.file);
        if (root == null) {
            AntiqueAtlasMod.logger.info("Biome texture config not found");
            return;
        }
        if (!root.isJsonObject()) {
            AntiqueAtlasMod.logger.error("Malformed biome texture config");
            return;
        }
        for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
            try {
                int biomeID = Integer.parseInt((String)entry.getKey());
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    for (JsonElement path : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!path.isJsonPrimitive()) {
                            AntiqueAtlasMod.logger.error("Malformed biome texture path: " + path.toString());
                            break;
                        }
                        ResourceLocation texture = new ResourceLocation(path.getAsString());
                        BiomeTextureMap.instance().setTexture(biomeID, texture);
                    }
                    AntiqueAtlasMod.logger.info("Registered custom texture for biome " + biomeID);
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    AntiqueAtlasMod.logger.error("Malformed biome texture config entry: " + ((JsonElement)entry.getValue()).toString());
                    break;
                }
                String textureSetName = ((JsonElement)entry.getValue()).getAsString();
                if (StandardTextureSet.contains(textureSetName)) {
                    BiomeTextureMap.instance().setTexture(biomeID, StandardTextureSet.valueOf(textureSetName));
                }
                AntiqueAtlasMod.logger.info("Registered standard texture set for biome " + biomeID);
            }
            catch (NumberFormatException e) {
                AntiqueAtlasMod.logger.error("Malformed biome texture config entry: " + e.toString());
                break;
            }
        }
    }

    public void save() {
        JsonObject root = new JsonObject();
        for (BiomeTextureMap.BiomeTextureEntry entry : BiomeTextureMap.instance().textureMap.values()) {
            if (entry.isStandardSet()) {
                root.addProperty(String.valueOf(entry.biomeID), entry.textureSet.name());
                continue;
            }
            JsonArray paths = new JsonArray();
            for (ResourceLocation texture : entry.textures) {
                paths.add((JsonElement)new JsonPrimitive(texture.toString()));
            }
            root.add(String.valueOf(entry.biomeID), (JsonElement)paths);
        }
        FileUtil.writeJson((JsonElement)root, this.file);
    }
}

