/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.client.gui.GuiComponentButton;
import hunternif.mc.atlas.client.gui.GuiRadioButton;
import hunternif.mc.atlas.client.gui.IButtonListener;
import hunternif.mc.atlas.client.gui.ISelectListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RadioGroup<B extends GuiRadioButton>
implements Iterable<B> {
    private final List<B> buttons = new ArrayList<B>();
    private final List<ISelectListener<? extends B>> listeners = new ArrayList<ISelectListener<? extends B>>();
    private B selectedButton = null;
    private final ClickListener clickListener = new ClickListener();

    public void addButton(B button) {
        this.buttons.add(button);
        ((GuiComponentButton)((Object)button)).addListener(this.clickListener);
        ((GuiRadioButton)((Object)button)).setRadioGroup(this);
    }

    public B getSelectedButton() {
        return this.selectedButton;
    }

    public void setSelectedButton(B button) {
        if (this.buttons.contains(button)) {
            if (this.selectedButton != null) {
                ((GuiRadioButton)((Object)this.selectedButton)).setSelected(false);
            }
            ((GuiRadioButton)((Object)button)).setSelected(true);
            this.selectedButton = button;
        }
    }

    @Override
    public Iterator<B> iterator() {
        return this.buttons.iterator();
    }

    public void addListener(ISelectListener<? extends B> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISelectListener<? extends B> listener) {
        this.listeners.remove(listener);
    }

    private class ClickListener
    implements IButtonListener<B> {
        private ClickListener() {
        }

        @Override
        public void onClick(B button) {
            if (button != RadioGroup.this.selectedButton) {
                if (RadioGroup.this.selectedButton != null) {
                    RadioGroup.this.selectedButton.setSelected(false);
                }
                RadioGroup.this.selectedButton = button;
                for (ISelectListener listener : RadioGroup.this.listeners) {
                    listener.onSelect(RadioGroup.this.selectedButton);
                }
            }
        }
    }
}

