/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;

public class MapTileStitcher {
    public static final MapTileStitcher instance = new MapTileStitcher();

    public void stitchAdjacentTiles(Map<ShortVec2, MapTile> tiles, ShortVec2 coords, MapTile tile) {
        MapTile top = tiles.get(coords.add(0, -1));
        MapTile topLeft = tiles.get(coords.add(-1, 0));
        MapTile left = tiles.get(coords.add(0, 1));
        MapTile bottomLeft = tiles.get(coords.add(0, 1));
        MapTile bottom = tiles.get(coords.add(1, 0));
        MapTile bottomRight = tiles.get(coords.add(1, 0));
        MapTile right = tiles.get(coords.add(0, -1));
        MapTile topRight = tiles.get(coords.add(0, -1));
        this.stitchVertically(top, tile);
        this.stitchVertically(tile, bottom);
        this.stitchHorizontally(left, tile);
        this.stitchHorizontally(tile, right);
        this.stitchSquare(topLeft, top, left, tile);
        this.stitchSquare(top, topRight, tile, right);
        this.stitchSquare(left, tile, bottomLeft, bottom);
        this.stitchSquare(tile, right, bottom, bottomRight);
    }

    public void stitchVertically(MapTile upper, MapTile lower) {
        if (upper == null || lower == null || !this.shouldStitch(upper.biomeID, lower.biomeID)) {
            return;
        }
        if (upper.bottomLeft == 0) {
            upper.bottomLeft = (byte)3;
        }
        if (upper.bottomLeft == 2) {
            upper.bottomLeft = 1;
        }
        if (upper.bottomRight == 0) {
            upper.bottomRight = (byte)3;
        }
        if (upper.bottomRight == 2) {
            upper.bottomRight = 1;
        }
        if (lower.topLeft == 0) {
            lower.topLeft = (byte)3;
        }
        if (lower.topLeft == 2) {
            lower.topLeft = 1;
        }
        if (lower.topRight == 0) {
            lower.topRight = (byte)3;
        }
        if (lower.topRight == 2) {
            lower.topRight = 1;
        }
    }

    public void stitchHorizontally(MapTile left, MapTile right) {
        if (left == null || right == null || !this.shouldStitch(left.biomeID, right.biomeID)) {
            return;
        }
        if (left.topRight == 0) {
            left.topRight = (byte)2;
        }
        if (left.topRight == 3) {
            left.topRight = 1;
        }
        if (left.bottomRight == 0) {
            left.bottomRight = (byte)2;
        }
        if (left.bottomRight == 3) {
            left.bottomRight = 1;
        }
        if (right.topLeft == 0) {
            right.topLeft = (byte)2;
        }
        if (right.topLeft == 3) {
            right.topLeft = 1;
        }
        if (right.bottomLeft == 0) {
            right.bottomLeft = (byte)2;
        }
        if (right.bottomLeft == 3) {
            right.bottomLeft = 1;
        }
    }

    public void stitchSquare(MapTile topLeft, MapTile topRight, MapTile bottomLeft, MapTile bottomRight) {
        if (topLeft == null || topRight == null || bottomLeft == null || bottomRight == null || !this.shouldStitch(topLeft.biomeID, topRight.biomeID, bottomLeft.biomeID, bottomRight.biomeID)) {
            return;
        }
        topLeft.bottomRight = (byte)4;
        topRight.bottomLeft = (byte)4;
        bottomLeft.topRight = (byte)4;
        bottomRight.topLeft = (byte)4;
    }

    public boolean shouldStitch(int ... biomeIDs) {
        return BiomeTextureMap.instance().haveSameTexture(biomeIDs);
    }
}

