/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.api.impl;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.client.StandardTextureSet;
import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.ext.ExtBiomeData;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.network.ModPacket;
import hunternif.mc.atlas.network.TileNameIDPacket;
import hunternif.mc.atlas.network.TilesPacket;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TileApiImpl
implements TileAPI {
    public final Map<String, Object> pendingTextures = new HashMap<String, Object>();
    public final Map<String, Object> pendingTexturesIfNone = new HashMap<String, Object>();

    @Override
    public void setTexture(String uniqueTileName, ResourceLocation ... textures) {
        int id = ExtTileIdMap.instance().getPseudoBiomeID(uniqueTileName);
        if (id != -1) {
            BiomeTextureMap.instance().setTexture(id, textures);
        } else {
            this.pendingTextures.put(uniqueTileName, textures);
        }
    }

    @Override
    public void setTexture(String uniqueTileName, StandardTextureSet textureSet) {
        int id = ExtTileIdMap.instance().getPseudoBiomeID(uniqueTileName);
        if (id != -1) {
            BiomeTextureMap.instance().setTexture(id, textureSet);
        } else {
            this.pendingTextures.put(uniqueTileName, (Object)textureSet);
        }
    }

    @Override
    public boolean setTextureIfNone(String uniqueTileName, ResourceLocation ... textures) {
        int id = ExtTileIdMap.instance().getPseudoBiomeID(uniqueTileName);
        if (id != -1) {
            return BiomeTextureMap.instance().setTextureIfNone(id, textures);
        }
        this.pendingTexturesIfNone.put(uniqueTileName, textures);
        return false;
    }

    @Override
    public boolean setTextureIfNone(String uniqueTileName, StandardTextureSet textureSet) {
        int id = ExtTileIdMap.instance().getPseudoBiomeID(uniqueTileName);
        if (id != -1) {
            return BiomeTextureMap.instance().setTextureIfNone(id, textureSet);
        }
        this.pendingTexturesIfNone.put(uniqueTileName, (Object)textureSet);
        return false;
    }

    @Override
    public void putCustomTile(World world, int dimension, String tileName, int chunkX, int chunkZ) {
        boolean isIdRegistered = ExtTileIdMap.instance().getPseudoBiomeID(tileName) != -1;
        int biomeID = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(tileName);
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        ShortVec2 coords = new ShortVec2(chunkX, chunkZ);
        data.setBiomeIdAt(dimension, biomeID, coords);
        if (!world.field_72995_K) {
            ModPacket packet;
            data.func_76185_a();
            if (!isIdRegistered) {
                packet = new TileNameIDPacket();
                ((TileNameIDPacket)packet).put(tileName, biomeID);
                AntiqueAtlasMod.packetPipeline.sendToWorld(packet, world);
            }
            packet = new TilesPacket(dimension);
            ((TilesPacket)packet).addTile(coords, biomeID);
            AntiqueAtlasMod.packetPipeline.sendToWorld(packet, world);
        }
    }
}

