/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import hunternif.mc.atlas.CommonProxy;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.api.BiomeAPI;
import hunternif.mc.atlas.api.MarkerAPI;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.client.StandardTextureSet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.core.BiomeTextureConfig;
import hunternif.mc.atlas.marker.MarkerTextureConfig;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;

public class ClientProxy
extends CommonProxy {
    private BiomeTextureConfig biomeTextureConfig;
    private MarkerTextureConfig markerTextureConfig;
    private GuiAtlas guiAtlas;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.biomeTextureConfig = new BiomeTextureConfig(new File(this.configDir, "textures.json"));
        this.biomeTextureConfig.load();
        this.markerTextureConfig = new MarkerTextureConfig(new File(this.configDir, "marker_textures.json"));
        this.markerTextureConfig.load();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.guiAtlas = new GuiAtlas();
        if (this.registerVillageTiles()) {
            this.updateBiomeTextureConfig();
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (this.assignVanillaTextures()) {
            this.updateBiomeTextureConfig();
        }
        if (this.setDefaultMarker()) {
            this.updateMarkerTextureConfig();
        }
    }

    @Override
    public void updateBiomeTextureConfig() {
        this.biomeTextureConfig.save();
    }

    @Override
    public void updateMarkerTextureConfig() {
        this.markerTextureConfig.save();
    }

    @Override
    public void openAtlasGUI(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            mc.func_147108_a((GuiScreen)this.guiAtlas.setAtlasItemStack(stack));
        }
    }

    private boolean assignVanillaTextures() {
        boolean changed = false;
        BiomeAPI api = AtlasAPI.getBiomeAPI();
        changed |= api.setTextureIfNone(BiomeGenBase.field_76771_b, StandardTextureSet.WATER);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76781_i, StandardTextureSet.WATER);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76776_l, StandardTextureSet.FROZEN_WATER);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76777_m, StandardTextureSet.FROZEN_WATER);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76787_r, StandardTextureSet.BEACH);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76769_d, StandardTextureSet.SAND);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76772_c, StandardTextureSet.PLAINS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76774_n, StandardTextureSet.SNOW);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76792_x, StandardTextureSet.JUNGLE_HILLS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76785_t, StandardTextureSet.FOREST_HILLS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76786_s, StandardTextureSet.HILLS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76770_e, StandardTextureSet.MOUNTAINS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76783_v, StandardTextureSet.MOUNTAINS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76775_o, StandardTextureSet.MOUNTAINS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76767_f, StandardTextureSet.FOREST);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76782_w, StandardTextureSet.JUNGLE);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76768_g, StandardTextureSet.PINES);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76784_u, StandardTextureSet.PINES_HILLS);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76780_h, StandardTextureSet.SWAMP);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76779_k, StandardTextureSet.BEACH);
        changed |= api.setTextureIfNone(BiomeGenBase.field_76789_p, StandardTextureSet.MUSHROOM);
        return changed |= api.setTextureIfNone(BiomeGenBase.field_76788_q, StandardTextureSet.BEACH);
    }

    private boolean setDefaultMarker() {
        boolean changed = false;
        MarkerAPI api = AtlasAPI.getMarkerAPI();
        changed |= api.setTextureIfNone("google", Textures.MARKER_GOOGLE_MARKER);
        changed |= api.setTextureIfNone("red_x_large", Textures.MARKER_RED_X_LARGE);
        return changed |= api.setTextureIfNone("red_x_small", Textures.MARKER_RED_X_SMALL);
    }

    private boolean registerVillageTiles() {
        boolean changed = false;
        TileAPI api = AtlasAPI.getTileAPI();
        changed |= api.setTextureIfNone("npcVillageDoor", StandardTextureSet.HOUSE);
        return changed |= api.setTextureIfNone("npcVillageTerritory", StandardTextureSet.FENCE);
    }
}

