/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.ext.ExtBiomeData;
import hunternif.mc.atlas.network.ModPacket;
import hunternif.mc.atlas.util.ShortVec2;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class TilesPacket
extends ModPacket {
    public static final int ENTRY_SIZE_BYTES = 6;
    private int dimension;
    private final Map<ShortVec2, Integer> biomeMap = new HashMap<ShortVec2, Integer>();

    public TilesPacket() {
    }

    public TilesPacket(int dimension) {
        this.dimension = dimension;
    }

    public TilesPacket addTile(ShortVec2 coords, int biomeID) {
        this.biomeMap.put(coords, biomeID);
        return this;
    }

    public boolean isEmpty() {
        return this.biomeMap.isEmpty();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeShort(this.dimension);
        buffer.writeShort(this.biomeMap.size());
        for (Map.Entry<ShortVec2, Integer> entry : this.biomeMap.entrySet()) {
            buffer.writeShort((int)entry.getKey().x);
            buffer.writeShort((int)entry.getKey().y);
            buffer.writeShort(entry.getValue().intValue());
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dimension = buffer.readShort();
        int length = buffer.readShort();
        for (int i = 0; i < length; ++i) {
            ShortVec2 coords = new ShortVec2(buffer.readShort(), buffer.readShort());
            this.biomeMap.put(coords, Integer.valueOf(buffer.readShort()));
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        for (Map.Entry<ShortVec2, Integer> entry : this.biomeMap.entrySet()) {
            data.setBiomeIdAt(this.dimension, entry.getValue(), entry.getKey());
        }
    }

    @Override
    protected boolean isCompressed() {
        return true;
    }
}

