/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.api.impl.TileApiImpl;
import hunternif.mc.atlas.client.StandardTextureSet;
import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.network.ModPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class TileNameIDPacket
extends ModPacket {
    private Map<String, Integer> nameToIdMap;

    public TileNameIDPacket() {
    }

    public TileNameIDPacket(Map<String, Integer> nameToIdMap) {
        this.nameToIdMap = nameToIdMap;
    }

    public TileNameIDPacket put(String name, int biomeID) {
        if (this.nameToIdMap == null) {
            this.nameToIdMap = new HashMap<String, Integer>();
        }
        this.nameToIdMap.put(name, biomeID);
        return this;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeShort(this.nameToIdMap.size());
        for (Map.Entry<String, Integer> entry : this.nameToIdMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
            buffer.writeShort(entry.getValue().intValue());
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int length = buffer.readShort();
        this.nameToIdMap = new HashMap<String, Integer>();
        for (int i = 0; i < length; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            this.nameToIdMap.put(name, Integer.valueOf(buffer.readShort()));
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileApiImpl api = (TileApiImpl)AtlasAPI.getTileAPI();
        for (Map.Entry<String, Integer> entry : this.nameToIdMap.entrySet()) {
            Object pending;
            String name = entry.getKey();
            int biomeID = entry.getValue();
            ExtTileIdMap.instance().setPseudoBiomeID(name, biomeID);
            if (api.pendingTextures.containsKey(name)) {
                pending = api.pendingTextures.remove(name);
                if (pending instanceof StandardTextureSet) {
                    BiomeTextureMap.instance().setTexture(biomeID, (StandardTextureSet)((Object)pending));
                } else if (pending instanceof ResourceLocation[]) {
                    BiomeTextureMap.instance().setTexture(biomeID, (ResourceLocation[])pending);
                }
                AntiqueAtlasMod.proxy.updateBiomeTextureConfig();
            }
            if (!api.pendingTexturesIfNone.containsKey(name)) continue;
            pending = api.pendingTexturesIfNone.remove(name);
            boolean textureChanged = false;
            if (pending instanceof StandardTextureSet) {
                textureChanged = BiomeTextureMap.instance().setTextureIfNone(biomeID, (StandardTextureSet)((Object)pending));
            } else if (pending instanceof ResourceLocation[]) {
                textureChanged = BiomeTextureMap.instance().setTextureIfNone(biomeID, (ResourceLocation[])pending);
            }
            if (!textureChanged) continue;
            AntiqueAtlasMod.proxy.updateBiomeTextureConfig();
        }
    }
}

