/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.network.ByteBufUtils;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.ModPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;

public class MarkersPacket
extends ModPacket {
    protected int atlasID;
    protected int dimension;
    protected final ListMultimap<String, Marker> markersByType = ArrayListMultimap.create();

    public MarkersPacket() {
    }

    public MarkersPacket(int atlasID, int dimension, Marker ... markers) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        for (Marker marker : markers) {
            this.markersByType.put((Object)marker.getType(), (Object)marker);
        }
    }

    public MarkersPacket putMarker(Marker marker) {
        this.markersByType.put((Object)marker.getType(), (Object)marker);
        return this;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeShort(this.atlasID);
        buffer.writeShort(this.dimension);
        Set types = this.markersByType.keySet();
        buffer.writeShort(types.size());
        for (String type : types) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)type);
            List markers = this.markersByType.get((Object)type);
            buffer.writeShort(markers.size());
            for (Marker marker : markers) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)marker.getLabel());
                buffer.writeInt(marker.getX());
                buffer.writeInt(marker.getY());
            }
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.atlasID = buffer.readShort();
        this.dimension = buffer.readShort();
        int typesLength = buffer.readShort();
        for (int i = 0; i < typesLength; ++i) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int markersLength = buffer.readShort();
            for (int j = 0; j < markersLength; ++j) {
                Marker marker = new Marker(type, ByteBufUtils.readUTF8String((ByteBuf)buffer), buffer.readInt(), buffer.readInt());
                this.markersByType.put((Object)type, (Object)marker);
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        MarkersData markersData = AntiqueAtlasMod.itemAtlas.getClientMarkersData(this.atlasID);
        for (Marker marker : this.markersByType.values()) {
            markersData.putMarker(this.dimension, marker);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        MarkersData markersData = AntiqueAtlasMod.itemAtlas.getMarkersData(this.atlasID, player.field_70170_p);
        for (Marker marker : this.markersByType.values()) {
            markersData.putMarker(this.dimension, marker);
        }
        markersData.func_76185_a();
        AntiqueAtlasMod.packetPipeline.sendToWorld(this, player.field_70170_p);
    }

    public boolean isEmpty() {
        return this.markersByType.isEmpty();
    }
}

