/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.CustomPacket;
import hunternif.mc.atlas.util.ZipUtil;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;

public class CustomPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            Side side;
            EntityPlayer entityPlayer = (EntityPlayer)player;
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])packet.data);
            int packetId = in.readUnsignedByte();
            CustomPacket customPacket = CustomPacket.constructPacket(packetId);
            if (customPacket.isCompressed()) {
                byte[] unzipped = ZipUtil.decompressByteArray((byte[])packet.data, (int)1);
                in = ByteStreams.newDataInput((byte[])unzipped);
            }
            Side side2 = side = entityPlayer.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
            if (side.isClient() && !customPacket.getPacketDirection().toClient) {
                throw new CustomPacket.ProtocolException("Can't send " + this.getClass().getSimpleName() + " to client");
            }
            if (!side.isClient() && !customPacket.getPacketDirection().toServer) {
                throw new CustomPacket.ProtocolException("Can't send " + this.getClass().getSimpleName() + " to server");
            }
            customPacket.read(in);
            customPacket.execute(entityPlayer, side);
        }
        catch (CustomPacket.ProtocolException e) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.kickPlayerFromServer("Protocol Exception!");
                AntiqueAtlasMod.logger.log(Level.WARNING, String.format("Player %s caused a Protocl Exception and was kicked.", ((EntityPlayer)player).username), e);
            } else {
                AntiqueAtlasMod.logger.log(Level.SEVERE, "Packet handler", e);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unexpected InstantiationException during Packet construction!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unexpected IllegalAccessException during Packet construction!", e);
        }
    }
}

