/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.client.Textures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public enum MarkerTextureMap {
    INSTANCE;

    private final Map<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();
    private final ResourceLocation defaultTexture = Textures.MARKER_RED_X_LARGE;

    public static MarkerTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(String markerType, ResourceLocation texture) {
        this.map.put(markerType, texture);
    }

    public boolean setTextureIfNone(String markerType, ResourceLocation texture) {
        if (this.map.containsKey(markerType)) {
            return false;
        }
        this.map.put(markerType, texture);
        return true;
    }

    public ResourceLocation getTexture(String markerType) {
        ResourceLocation texture = this.map.get(markerType);
        return texture == null ? this.defaultTexture : texture;
    }

    Map<String, ResourceLocation> getMap() {
        return this.map;
    }
}

