/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.MapTileStitcher;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.ChunkBiomeAnalyzer;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.util.ByteUtil;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;

public class ItemAtlas
extends Item {
    protected static final String ATLAS_DATA_PREFIX = "aAtlas_";
    protected static final String WORLD_ATLAS_DATA_ID = "aAtlas";
    protected static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    public static double LOOK_RADIUS = 11.0;
    public static int UPDATE_INTERVAL = 20;
    private ChunkBiomeAnalyzer biomeAnalyzer;

    public ItemAtlas() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public void setBiomeAnalyzer(ChunkBiomeAnalyzer biomeAnalyzer) {
        this.biomeAnalyzer = biomeAnalyzer;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("antiqueatlas:" + this.func_77658_a().substring("item.".length()));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)"gui.antiqueatlas.atlasTitle", (Object[])new Object[]{stack.func_77960_j()});
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            AntiqueAtlasMod.proxy.openAtlasGUI(stack);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isEquipped) {
        AtlasData data = this.getAtlasData(stack, world);
        if (data == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!(world.field_72995_K || data.isSyncedOnPlayer(player) || data.isEmpty())) {
            data.syncOnPlayer(stack.func_77960_j(), player);
        }
        MarkersData markers = this.getMarkersData(stack, world);
        if (!(world.field_72995_K || markers.isSyncedOnPlayer(player) || markers.isEmpty())) {
            markers.syncOnPlayer(stack.func_77960_j(), player);
        }
        if (player.field_70173_aa % UPDATE_INTERVAL != 0 || this.biomeAnalyzer == null) {
            return;
        }
        int playerX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int playerZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        Map<ShortVec2, MapTile> seenChunks = data.getSeenChunksInDimension(player.field_71093_bK);
        ShortVec2 coords = new ShortVec2(0, 0);
        for (double dx = -LOOK_RADIUS; dx <= LOOK_RADIUS; dx += 1.0) {
            for (double dz = -LOOK_RADIUS; dz <= LOOK_RADIUS; dz += 1.0) {
                MapTile tile;
                if (dx * dx + dz * dz > LOOK_RADIUS * LOOK_RADIUS) continue;
                coords.x = (short)((double)playerX + dx);
                coords.y = (short)((double)playerZ + dz);
                int biomeId = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(player.field_71093_bK, coords);
                if (biomeId == -1) {
                    if (seenChunks.containsKey(coords) || !player.field_70170_p.func_72899_e(coords.x << 4, 0, coords.y << 4)) continue;
                    Chunk chunk = player.field_70170_p.func_72964_e((int)coords.x, (int)coords.y);
                    biomeId = !chunk.field_76636_d ? -1 : this.biomeAnalyzer.getMeanBiomeID(ByteUtil.unsignedByteToIntArray(chunk.func_76605_m()));
                    if (biomeId == -1) continue;
                    tile = new MapTile(biomeId);
                    if (world.field_72995_K) {
                        tile.randomizeTexture();
                    }
                    data.putTile(player.field_71093_bK, coords.clone(), tile);
                    if (world.field_72995_K) continue;
                    data.func_76185_a();
                    continue;
                }
                MapTile oldTile = seenChunks.get(coords);
                if (oldTile != null && oldTile.biomeID == biomeId) continue;
                tile = new MapTile(biomeId);
                if (world.field_72995_K) {
                    tile.randomizeTexture();
                }
                data.putTile(player.field_71093_bK, coords.clone(), tile);
                if (world.field_72995_K) continue;
                data.func_76185_a();
            }
        }
    }

    public AtlasData getAtlasData(ItemStack stack, World world) {
        String key = this.getAtlasDataKey(stack);
        AtlasData data = (AtlasData)world.func_72943_a(AtlasData.class, key);
        if (data == null && !world.field_72995_K) {
            stack.func_77964_b(world.func_72841_b(WORLD_ATLAS_DATA_ID));
            key = this.getAtlasDataKey(stack);
            data = new AtlasData(key);
            world.func_72823_a(key, (WorldSavedData)data);
            if (world.field_72995_K) {
                data.setTileStitcher(MapTileStitcher.instance);
            }
        }
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public AtlasData getClientAtlasData(int atlasID) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        String key = this.getAtlasDataKey(atlasID);
        AtlasData data = (AtlasData)world.func_72943_a(AtlasData.class, key);
        if (data == null) {
            data = new AtlasData(key);
            data.setTileStitcher(MapTileStitcher.instance);
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    protected String getAtlasDataKey(ItemStack stack) {
        return this.getAtlasDataKey(stack.func_77960_j());
    }

    protected String getAtlasDataKey(int atlasID) {
        return ATLAS_DATA_PREFIX + atlasID;
    }

    public MarkersData getMarkersData(ItemStack stack, World world) {
        String key = this.getMarkersDataKey(stack);
        MarkersData data = (MarkersData)world.func_72943_a(MarkersData.class, key);
        if (data == null && !world.field_72995_K) {
            data = new MarkersData(key);
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    public MarkersData getMarkersData(int atlasID, World world) {
        String key = this.getMarkersDataKey(atlasID);
        MarkersData data = (MarkersData)world.func_72943_a(MarkersData.class, key);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public MarkersData getClientMarkersData(int atlasID) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        String key = this.getMarkersDataKey(atlasID);
        MarkersData data = (MarkersData)world.func_72943_a(MarkersData.class, key);
        if (data == null) {
            data = new MarkersData(key);
            world.func_72823_a(key, (WorldSavedData)data);
        }
        return data;
    }

    protected String getMarkersDataKey(ItemStack stack) {
        return this.getMarkersDataKey(stack.func_77960_j());
    }

    protected String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }
}

