/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.core.BiomeTextureMap;
import java.util.Random;

public class MapTile {
    public final int biomeID;
    private transient byte variationNumber;
    public static final byte CONVEX = 0;
    public static final byte CONCAVE = 1;
    public static final byte HORIZONTAL = 2;
    public static final byte VERTICAL = 3;
    public static final byte FULL = 4;
    public transient byte topLeft = 0;
    public transient byte topRight = 0;
    public transient byte bottomLeft = 0;
    public transient byte bottomRight = 0;

    public boolean isSingleObject() {
        return this.topLeft == 0 && this.topRight == 0 && this.bottomLeft == 0 && this.bottomRight == 0;
    }

    public MapTile(int biomeID) {
        this.biomeID = biomeID;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomizeTexture() {
        int maxVariations = BiomeTextureMap.instance().getVariations(this.biomeID);
        this.variationNumber = maxVariations <= 0 ? (byte)0 : (byte)new Random().nextInt(maxVariations);
    }

    @SideOnly(value=Side.CLIENT)
    public int getVariationNumber() {
        return this.variationNumber;
    }

    public String toString() {
        return "tile" + this.biomeID;
    }
}

