/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DimensionData {
    public final int dimension;
    private final Map<ShortVec2, MapTile> tiles;
    private short minX = Short.MAX_VALUE;
    private short maxX = Short.MIN_VALUE;
    private short minY = Short.MAX_VALUE;
    private short maxY = Short.MIN_VALUE;

    protected DimensionData(int dimension) {
        this(dimension, new ConcurrentHashMap<ShortVec2, MapTile>());
    }

    protected DimensionData(int dimension, Map<ShortVec2, MapTile> tiles) {
        this.dimension = dimension;
        this.tiles = tiles;
    }

    public Map<ShortVec2, MapTile> getSeenChunks() {
        return this.tiles;
    }

    protected void putTile(ShortVec2 tileCoords, MapTile tile) {
        this.tiles.put(tileCoords, tile);
        if (tileCoords.x < this.minX) {
            this.minX = tileCoords.x;
        }
        if (tileCoords.x > this.maxX) {
            this.maxX = tileCoords.x;
        }
        if (tileCoords.y < this.minY) {
            this.minY = tileCoords.y;
        }
        if (tileCoords.y > this.maxY) {
            this.maxY = tileCoords.y;
        }
    }

    public short getMinX() {
        return this.minX;
    }

    public short getMaxX() {
        return this.maxX;
    }

    public short getMinY() {
        return this.minY;
    }

    public short getMaxY() {
        return this.maxY;
    }
}

