/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class ChunkBiomeAnalyzer {
    public static final int NOT_FOUND = -1;

    public int getMeanBiomeID(int[] biomeIDs) {
        BiomeGenBase[] biomes = BiomeGenBase.func_150565_n();
        int[] biomeOccurences = new int[biomes.length];
        for (int i = 0; i < biomes.length; ++i) {
            int biomeId = biomeIDs[i];
            if (biomeId < 0 || biomeId >= biomes.length || biomes[biomeId] == null) continue;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[biomeId], (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                int n = biomeId;
                biomeOccurences[n] = biomeOccurences[n] + 4;
                continue;
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biomes[biomeId], (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                int n = biomeId;
                biomeOccurences[n] = biomeOccurences[n] + 6;
                continue;
            }
            int n = biomeId;
            biomeOccurences[n] = biomeOccurences[n] + 1;
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurences.length; ++i) {
            if (biomeOccurences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurences[i];
        }
        return meanBiomeId;
    }
}

