/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.StandardTextureSet;
import hunternif.mc.atlas.core.MapTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

@SideOnly(value=Side.CLIENT)
public enum BiomeTextureMap {
    INSTANCE;

    final Map<Integer, BiomeTextureEntry> textureMap = new HashMap<Integer, BiomeTextureEntry>();
    public static final StandardTextureSet defaultTexture;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public boolean setTextureIfNone(int biomeID, StandardTextureSet textureSet) {
        if (!this.isRegistered(biomeID)) {
            this.setTexture(biomeID, textureSet);
            return true;
        }
        return false;
    }

    public boolean setTextureIfNone(int biomeID, ResourceLocation ... textures) {
        if (!this.isRegistered(biomeID)) {
            this.setTexture(biomeID, textures);
            return true;
        }
        return false;
    }

    public void setTexture(int biomeID, StandardTextureSet textureSet) {
        BiomeTextureEntry entry = this.textureMap.get(biomeID);
        if (entry == null) {
            entry = new BiomeTextureEntry(biomeID, textureSet);
            this.textureMap.put(biomeID, entry);
        } else {
            if (!entry.textureSet.equals((Object)textureSet)) {
                entry.textureSet = null;
            }
            if (!entry.textures.isEmpty()) {
                AntiqueAtlasMod.logger.warn("Overwriting textures for biome " + biomeID);
            }
            entry.textures.clear();
            for (ResourceLocation texture : textureSet.textures) {
                entry.textures.add(texture);
            }
        }
    }

    public void setTexture(int biomeID, ResourceLocation ... textures) {
        BiomeTextureEntry entry = this.textureMap.get(biomeID);
        if (entry == null) {
            entry = new BiomeTextureEntry(biomeID, textures);
            this.textureMap.put(biomeID, entry);
        } else {
            if (!entry.textures.isEmpty()) {
                AntiqueAtlasMod.logger.warn("Overwriting textures for biome " + biomeID);
            }
            entry.textures.clear();
            for (ResourceLocation texture : textures) {
                entry.textures.add(texture);
            }
        }
    }

    private void autoRegister(int biomeID) {
        if (biomeID < 0 || biomeID >= 256) {
            AntiqueAtlasMod.logger.warn("Biome ID " + biomeID + " is out of range. " + "Auto-registering default texture set");
            this.setTexture(biomeID, defaultTexture);
            return;
        }
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeID);
        if (biome == null) {
            AntiqueAtlasMod.logger.warn("Biome ID " + biomeID + " is null. " + "Auto-registering default texture set");
            this.setTexture(biomeID, defaultTexture);
            return;
        }
        List<BiomeDictionary.Type> types = Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome));
        if (types.contains(BiomeDictionary.Type.SWAMP)) {
            this.setTexture(biomeID, StandardTextureSet.SWAMP);
        } else if (types.contains(BiomeDictionary.Type.WATER)) {
            if (types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.JUNGLE) || types.contains(BiomeDictionary.Type.SWAMP)) {
                this.setTexture(biomeID, StandardTextureSet.SWAMP);
            } else if (types.contains(BiomeDictionary.Type.FROZEN)) {
                this.setTexture(biomeID, StandardTextureSet.FROZEN_WATER);
            } else {
                this.setTexture(biomeID, StandardTextureSet.WATER);
            }
        } else if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
            this.setTexture(biomeID, StandardTextureSet.MOUNTAINS);
        } else if (types.contains(BiomeDictionary.Type.HILLS)) {
            if (types.contains(BiomeDictionary.Type.FOREST)) {
                if (types.contains(BiomeDictionary.Type.FROZEN)) {
                    this.setTexture(biomeID, StandardTextureSet.PINES_HILLS);
                } else {
                    this.setTexture(biomeID, StandardTextureSet.FOREST_HILLS);
                }
            } else if (types.contains(BiomeDictionary.Type.JUNGLE)) {
                this.setTexture(biomeID, StandardTextureSet.JUNGLE_HILLS);
            } else {
                this.setTexture(biomeID, StandardTextureSet.HILLS);
            }
        } else if (types.contains(BiomeDictionary.Type.JUNGLE)) {
            this.setTexture(biomeID, StandardTextureSet.JUNGLE);
        } else if (types.contains(BiomeDictionary.Type.FOREST)) {
            if (types.contains(BiomeDictionary.Type.FROZEN)) {
                this.setTexture(biomeID, StandardTextureSet.PINES);
            } else {
                this.setTexture(biomeID, StandardTextureSet.FOREST);
            }
        } else if (types.contains(BiomeDictionary.Type.DESERT) || types.contains(BiomeDictionary.Type.WASTELAND)) {
            if (types.contains(BiomeDictionary.Type.FROZEN)) {
                this.setTexture(biomeID, StandardTextureSet.SNOW);
            } else {
                this.setTexture(biomeID, StandardTextureSet.SAND);
            }
        } else if (types.contains(BiomeDictionary.Type.BEACH)) {
            this.setTexture(biomeID, StandardTextureSet.BEACH);
        } else {
            this.setTexture(biomeID, defaultTexture);
        }
        AntiqueAtlasMod.logger.info("Auto-registered standard texture set for biome " + biomeID);
    }

    public void checkRegistration(int biomeID) {
        if (!this.isRegistered(biomeID)) {
            this.autoRegister(biomeID);
            AntiqueAtlasMod.proxy.updateBiomeTextureConfig();
        }
    }

    public boolean isRegistered(int biomeID) {
        return this.textureMap.containsKey(biomeID);
    }

    public int getVariations(int biomeID) {
        this.checkRegistration(biomeID);
        BiomeTextureEntry entry = this.textureMap.get(biomeID);
        return entry.textures.size();
    }

    public ResourceLocation getTexture(MapTile tile) {
        this.checkRegistration(tile.biomeID);
        BiomeTextureEntry entry = this.textureMap.get(tile.biomeID);
        return entry.textures.get(tile.getVariationNumber());
    }

    public boolean haveSameTexture(int ... biomeIDs) {
        ArrayList<ResourceLocation> textures = null;
        for (int biomeID : biomeIDs) {
            this.checkRegistration(biomeID);
            if (textures == null) {
                this.textureMap.get(biomeID);
                textures = new ArrayList<ResourceLocation>(this.textureMap.get((Object)Integer.valueOf((int)biomeID)).textures);
                continue;
            }
            textures.retainAll(this.textureMap.get((Object)Integer.valueOf((int)biomeID)).textures);
        }
        return !textures.isEmpty();
    }

    public static boolean areBiomesEqual(BiomeGenBase ... biomes) {
        for (int i = 1; i < biomes.length; ++i) {
            if (biomes[0] == biomes[i]) continue;
            return false;
        }
        return true;
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<Integer, BiomeTextureEntry> entry : this.textureMap.entrySet()) {
            list.addAll(entry.getValue().textures);
        }
        return list;
    }

    static {
        defaultTexture = StandardTextureSet.PLAINS;
    }

    static class BiomeTextureEntry {
        public final int biomeID;
        public StandardTextureSet textureSet;
        public final List<ResourceLocation> textures;

        public BiomeTextureEntry(int biomeID, ResourceLocation ... textures) {
            this(biomeID, (StandardTextureSet)null, textures);
        }

        public BiomeTextureEntry(int biomeID, StandardTextureSet textureSet) {
            this(biomeID, textureSet, textureSet.textures);
        }

        public BiomeTextureEntry(int biomeID, StandardTextureSet textureSet, ResourceLocation ... textures) {
            this.biomeID = biomeID;
            this.textureSet = textureSet;
            this.textures = new ArrayList<ResourceLocation>();
            for (ResourceLocation texture : textures) {
                this.textures.add(texture);
            }
        }

        public boolean isStandardSet() {
            return this.textureSet != null;
        }

        public String toString() {
            if (this.isStandardSet()) {
                return this.textureSet.name();
            }
            return this.textures.toString();
        }
    }
}

