/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.MapTileStitcher;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.network.MapDataPacket;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class AtlasData
extends WorldSavedData {
    private static final String TAG_DIMENSION_MAP_LIST = "qDimensionMap";
    private static final String TAG_DIMENSION_ID = "qDimensionID";
    private static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    private Map<Integer, DimensionData> dimensionMap = new ConcurrentHashMap<Integer, DimensionData>();
    private MapTileStitcher tileStitcher;
    private final Set<EntityPlayer> playersSentTo = new HashSet<EntityPlayer>();

    public AtlasData(String key) {
        super(key);
    }

    public void setTileStitcher(MapTileStitcher tileStitcher) {
        this.tileStitcher = tileStitcher;
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound tag = dimensionMapList.func_150305_b(d);
            int dimensionID = tag.func_74762_e(TAG_DIMENSION_ID);
            int[] intArray = tag.func_74759_k(TAG_VISITED_CHUNKS);
            for (int i = 0; i < intArray.length; i += 3) {
                ShortVec2 coords = new ShortVec2(intArray[i], intArray[i + 1]);
                this.putTile(dimensionID, coords, new MapTile(intArray[i + 2]));
            }
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList dimensionMapList = new NBTTagList();
        for (Map.Entry<Integer, DimensionData> dimensionEntry : this.dimensionMap.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_DIMENSION_ID, dimensionEntry.getKey().intValue());
            Map<ShortVec2, MapTile> seenChunks = dimensionEntry.getValue().getSeenChunks();
            int[] intArray = new int[seenChunks.size() * 3];
            int i = 0;
            for (Map.Entry<ShortVec2, MapTile> entry : seenChunks.entrySet()) {
                intArray[i++] = entry.getKey().x;
                intArray[i++] = entry.getKey().y;
                intArray[i++] = entry.getValue().biomeID;
            }
            tag.func_74783_a(TAG_VISITED_CHUNKS, intArray);
            dimensionMapList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
    }

    public void putTile(int dimension, ShortVec2 tileCoords, MapTile tile) {
        DimensionData dimData = this.getDimensionData(dimension);
        dimData.putTile(tileCoords, tile);
        if (this.tileStitcher != null) {
            this.tileStitcher.stitchAdjacentTiles(dimData.getSeenChunks(), new ShortVec2(tileCoords), tile);
        }
    }

    public Set<Integer> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public DimensionData getDimensionData(int dimension) {
        DimensionData dimData = this.dimensionMap.get(dimension);
        if (dimData == null) {
            dimData = new DimensionData(dimension);
            this.dimensionMap.put(dimension, dimData);
        }
        return dimData;
    }

    public Map<ShortVec2, MapTile> getSeenChunksInDimension(int dimension) {
        return this.getDimensionData(dimension).getSeenChunks();
    }

    public boolean isSyncedOnPlayer(EntityPlayer player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        int pieces = 0;
        int dataSizeBytes = 0;
        HashMap<ShortVec2, MapTile> data = new HashMap<ShortVec2, MapTile>();
        for (Integer dimension : this.getVisitedDimensions()) {
            Map<ShortVec2, MapTile> seenChunks = this.getSeenChunksInDimension(dimension);
            for (Map.Entry<ShortVec2, MapTile> entry : seenChunks.entrySet()) {
                data.put(entry.getKey(), entry.getValue());
                if ((dataSizeBytes += 6) < 32000) continue;
                MapDataPacket packet = new MapDataPacket(atlasID, dimension, data);
                AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
                ++pieces;
                dataSizeBytes = 0;
                data.clear();
            }
            if (data.size() <= 0) continue;
            MapDataPacket packet = new MapDataPacket(atlasID, dimension, data);
            AntiqueAtlasMod.packetPipeline.sendTo(packet, player);
            ++pieces;
            dataSizeBytes = 0;
            data.clear();
        }
        AntiqueAtlasMod.logger.info("Sent Atlas #" + atlasID + " data to player " + player.func_70005_c_() + " in " + pieces + " pieces.");
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.dimensionMap.isEmpty();
    }
}

