/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiComponent
extends GuiScreen {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    protected int contentWidth;
    protected int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    public final void setCentered() {
        this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    public int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    public int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public GuiComponent addChild(GuiComponent child) {
        if (child != null && !this.children.contains((Object)child) && this.parent != child) {
            this.children.add(child);
            child.parent = this;
            child.setGuiCoords(this.guiX, this.guiY);
            if (this.field_146297_k != null) {
                child.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            this.invalidateSize();
        }
        return child;
    }

    public GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
        }
        return child;
    }

    public void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    public List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
        this.field_146291_p = !this.interceptsMouse | !this.interceptsKeyboard;
    }

    public void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
        this.field_146291_p = !this.interceptsMouse | !this.interceptsKeyboard;
    }

    public void func_146269_k() {
        if (this.interceptsMouse) {
            while (Mouse.next()) {
                this.func_146274_d();
            }
        }
        if (this.interceptsKeyboard) {
            while (Keyboard.next()) {
                this.func_146282_l();
            }
        }
    }

    public void func_146274_d() {
        for (GuiComponent child : this.children) {
            child.func_146274_d();
        }
        super.func_146274_d();
    }

    public void func_146282_l() {
        for (GuiComponent child : this.children) {
            child.func_146282_l();
        }
        super.func_146282_l();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        super.func_73863_a(mouseX, mouseY, partialTick);
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.func_73863_a(mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            boolean unicode = this.hoveringTextInfo.font.func_82883_a();
            this.hoveringTextInfo.font.func_78264_a(false);
            this.drawHoveringText2(this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
            this.hoveringTextInfo.font.func_78264_a(unicode);
        }
    }

    public void func_146281_b() {
        for (GuiComponent child : this.children) {
            child.func_146281_b();
        }
        super.func_146281_b();
    }

    public void func_73876_c() {
        for (GuiComponent child : this.children) {
            child.func_73876_c();
        }
        super.func_73876_c();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        for (GuiComponent child : this.children) {
            child.func_146280_a(mc, width, height);
        }
        super.func_146280_a(mc, width, height);
    }

    public int getWidth() {
        return this.contentWidth;
    }

    public int getHeight() {
        return this.contentHeight;
    }

    protected void setClipped(boolean value) {
        this.isClipped = value;
    }

    protected void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    protected void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(0, rightmost - leftmost);
        this.contentHeight = Math.max(0, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    protected boolean isPointInRegion(int left, int top, int width, int height, int mouseX, int mouseY) {
        return (mouseX -= this.getGuiX()) >= left - 1 && mouseX < left + width + 1 && (mouseY -= this.getGuiY()) >= top - 1 && mouseY < top + height + 1;
    }

    protected boolean isPointInRadius(int x, int y, int radius, int mouseX, int mouseY) {
        return mouseX >= x - radius && mouseX < x + radius && mouseY >= y - radius && mouseY < y + radius;
    }

    protected void drawHoveringText2(List<String> lines, int x, int y, FontRenderer font) {
        if (!lines.isEmpty()) {
            boolean stencilEnabled = GL11.glIsEnabled((int)2960);
            if (stencilEnabled) {
                GL11.glDisable((int)2960);
            }
            RenderHelper.func_74518_a();
            int k = 0;
            for (String s : lines) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (lines.size() > 1) {
                k1 += 2 + (lines.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < lines.size(); ++k2) {
                String s1 = lines.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            if (stencilEnabled) {
                GL11.glEnable((int)2960);
            }
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.guiX && mouseY >= this.guiY && mouseX < this.guiX + this.getWidth() && mouseY < this.guiY + this.getHeight();
    }

    public GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTopLevelHoveringText(List<String> lines, int x, int y, FontRenderer font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = x;
        topLevel.hoveringTextInfo.y = y;
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void close() {
        if (this.parent != null) {
            GuiComponent oldParent = this.parent;
            this.parent.removeChild(this);
            oldParent.onChildClosed(this);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCenteredString(String text, int y, int color, boolean dropShadow) {
        int length = this.field_146289_q.func_78256_a(text);
        this.field_146289_q.func_85187_a(text, (this.field_146294_l - length) / 2, y, color, dropShadow);
    }

    private static class HoveringTextInfo {
        List<String> lines;
        int x;
        int y;
        FontRenderer font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }
}

