/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.GuiArrowButton;
import hunternif.mc.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.atlas.client.gui.GuiComponent;
import hunternif.mc.atlas.client.gui.GuiComponentButton;
import hunternif.mc.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.atlas.client.gui.GuiPositionButton;
import hunternif.mc.atlas.client.gui.GuiScaleBar;
import hunternif.mc.atlas.client.gui.IButtonListener;
import hunternif.mc.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.BiomeTextureMap;
import hunternif.mc.atlas.core.MapTile;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkerTextureMap;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.ExportImageUtil;
import hunternif.mc.atlas.util.ShortVec2;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int CONTENT_X = 17;
    private static final int CONTENT_Y = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    private static final int MARKER_ICON_WIDTH = 16;
    private static final int MARKER_ICON_HEIGHT = 16;
    private static final int MARKER_RADIUS = 4;
    private GuiArrowButton btnUp;
    private GuiArrowButton btnDown;
    private GuiArrowButton btnLeft;
    private GuiArrowButton btnRight;
    private GuiBookmarkButton btnExportPng;
    private GuiBookmarkButton btnMarker;
    private GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    public static int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int dragMouseX;
    private int dragMouseY;
    private int dragMapOffsetX;
    private int dragMapOffsetY;
    private int mapOffsetX;
    private int mapOffsetY;
    private boolean followPlayer = true;
    private GuiScaleBar scaleBar = new GuiScaleBar();
    private double mapScale = 0.5;
    private ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);
    private volatile boolean isExporting = false;
    private final SortedSet<Marker> visibleMarkers = new TreeSet<Marker>();
    private boolean isPlacingMarker = false;
    private boolean isEnteringMarkerLabel = false;
    private GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private EntityPlayer player;
    private ItemStack stack;
    private int screenScale;

    public GuiAtlas() {
        this.setInterceptKeyboard(false);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener positionListener = new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                GuiAtlas.this.selectedButton = button;
                if (((Object)((Object)button)).equals((Object)GuiAtlas.this.btnPosition)) {
                    GuiAtlas.this.followPlayer = true;
                    GuiAtlas.this.btnPosition.setEnabled(false);
                } else {
                    GuiAtlas.this.navigateByButton(GuiAtlas.this.selectedButton);
                    GuiAtlas.this.timeButtonPressed = ((GuiAtlas)GuiAtlas.this).player.field_70170_p.func_82737_E();
                }
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(1, Textures.ICON_EXPORT, I18n.func_135052_a((String)"gui.antiqueatlas.exportImage", (Object[])new Object[0]));
        this.addChild(this.btnExportPng).offsetGuiCoords(299, 190);
        this.btnExportPng.addListener(new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                GuiAtlas.this.progressBar.reset();
                if (GuiAtlas.this.stack != null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            GuiAtlas.this.exportImage(GuiAtlas.this.stack.func_77946_l());
                        }
                    }).start();
                }
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_MARKER, I18n.func_135052_a((String)"gui.antiqueatlas.addMarker", (Object[])new Object[0]));
        this.addChild(this.btnMarker).offsetGuiCoords(299, 171);
        this.btnMarker.addListener(new IButtonListener(){

            public void onClick(GuiComponentButton button) {
                if (GuiAtlas.this.stack != null && !GuiAtlas.this.isPlacingMarker && !GuiAtlas.this.isEnteringMarkerLabel) {
                    GuiAtlas.this.selectedButton = button;
                    GuiAtlas.this.isPlacingMarker = true;
                }
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 190);
        this.scaleBar.setMapScale(1.0);
    }

    public GuiAtlas setAtlasItemStack(ItemStack stack) {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.stack = stack;
        return this;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.screenScale = new ScaledResolution(this.field_146297_k.field_71474_y, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d).func_78325_e();
        this.setGuiCoords((this.field_146294_l - 310) / 2, (this.field_146295_m - 218) / 2);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseState) {
        boolean isMouseOverMap;
        super.func_73864_a(mouseX, mouseY, mouseState);
        int mapX = (this.field_146294_l - 276) / 2;
        int mapY = (this.field_146295_m - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= mapX && mouseX <= mapX + 276 && mouseY >= mapY && mouseY <= mapY + 194;
        if (this.isPlacingMarker) {
            if (this.selectedButton == this.btnMarker) {
                this.selectedButton = null;
            } else {
                if (isMouseOverMap && mouseState == 0) {
                    this.isEnteringMarkerLabel = true;
                    this.markerFinalizer.setMarkerData(this.player.field_70170_p, this.stack.func_77960_j(), this.player.field_71093_bK, this.screenXToWorldX(mouseX), this.screenYToWorldZ(mouseY));
                    this.addChild(this.markerFinalizer).setCentered();
                    this.setInterceptKeyboard(true);
                }
                this.isPlacingMarker = false;
            }
        } else if (isMouseOverMap && this.selectedButton == null) {
            this.isDragging = true;
            this.dragMouseX = mouseX;
            this.dragMouseY = mouseY;
            this.dragMapOffsetX = this.mapOffsetX;
            this.dragMapOffsetY = this.mapOffsetY;
        }
    }

    private void exportImage(ItemStack stack) {
        this.isExporting = true;
        File file = ExportImageUtil.selectPngFileToSave("Atlas " + stack.func_77960_j(), this.progressBar);
        if (file != null) {
            AntiqueAtlasMod.logger.info("Exporting image from Atlas #" + stack.func_77960_j() + " to file " + file.getAbsolutePath());
            AtlasData data = AntiqueAtlasMod.itemAtlas.getAtlasData(stack, this.player.field_70170_p);
            ExportImageUtil.exportPngImage(data.getDimensionData(this.player.field_71093_bK), file, this.progressBar);
            AntiqueAtlasMod.logger.info("Finished exporting image");
        }
        this.isExporting = false;
    }

    @Override
    public void func_146282_l() {
        if (Keyboard.getEventKeyState()) {
            int key = Keyboard.getEventKey();
            if (key == 200) {
                this.navigateMap(0, navigateStep);
            } else if (key == 208) {
                this.navigateMap(0, -navigateStep);
            } else if (key == 203) {
                this.navigateMap(navigateStep, 0);
            } else if (key == 205) {
                this.navigateMap(-navigateStep, 0);
            } else if (key == 78 || key == 13) {
                this.setMapScale(this.mapScale * 2.0);
            } else if (key == 74 || key == 12) {
                this.setMapScale(this.mapScale / 2.0);
            }
        }
        super.func_146282_l();
    }

    @Override
    public void func_146274_d() {
        super.func_146274_d();
        int wheelMove = Mouse.getEventDWheel();
        if (wheelMove != 0) {
            wheelMove = wheelMove > 0 ? -1 : 1;
            this.setMapScale(this.mapScale * Math.pow(2.0, wheelMove));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseState) {
        super.func_146286_b(mouseX, mouseY, mouseState);
        if (mouseState != -1) {
            this.selectedButton = null;
            this.isDragging = false;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int lastMouseButton, long timeSinceMouseClick) {
        super.func_146273_a(mouseX, mouseY, lastMouseButton, timeSinceMouseClick);
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetX = this.dragMapOffsetX + mouseX - this.dragMouseX;
            this.mapOffsetY = this.dragMapOffsetY + mouseY - this.dragMouseY;
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.followPlayer) {
            this.mapOffsetX = (int)(-this.player.field_70165_t * this.mapScale);
            this.mapOffsetY = (int)(-this.player.field_70161_v * this.mapScale);
        }
        if (this.player.field_70170_p.func_82737_E() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, navigateStep);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -navigateStep);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(navigateStep, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-navigateStep, 0);
        }
    }

    public void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    public void setMapScale(double scale) {
        double oldScale = this.mapScale;
        this.mapScale = scale;
        if (this.mapScale < 0.25) {
            this.mapScale = 0.25;
        }
        if (this.mapScale > 1.0) {
            this.mapScale = 1.0;
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)this.mapOffsetX * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)this.mapOffsetY * (this.mapScale / oldScale));
        this.dragMapOffsetX = (int)((double)this.dragMapOffsetX * (this.mapScale / oldScale));
        this.dragMapOffsetY = (int)((double)this.dragMapOffsetY * (this.mapScale / oldScale));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, this.getGuiX(), this.getGuiY(), 310, 218);
        if (this.stack == null) {
            return;
        }
        AtlasData data = AntiqueAtlasMod.itemAtlas.getAtlasData(this.stack, this.player.field_70170_p);
        if (data == null) {
            return;
        }
        GlobalMarkersData globalMarkers = AntiqueAtlasMod.globalMarkersData.getData();
        MarkersData localMarkers = AntiqueAtlasMod.itemAtlas.getMarkersData(this.stack, this.player.field_70170_p);
        this.visibleMarkers.clear();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.getGuiX() + 17) * this.screenScale), (int)(this.field_146297_k.field_71440_d - (this.getGuiY() + 11 + 194) * this.screenScale), (int)(276 * this.screenScale), (int)(194 * this.screenScale));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Map<ShortVec2, MapTile> tiles = data.getSeenChunksInDimension(this.player.field_71093_bK);
        ShortVec2 mapStartCoords = new ShortVec2(Math.round(-(138.0 + (double)this.mapOffsetX) / this.mapScale) >> 4, Math.round(-(97.0 + (double)this.mapOffsetY) / this.mapScale) >> 4);
        ShortVec2 chunkCoords = new ShortVec2(mapStartCoords);
        int screenX = this.getGuiX() + 155 + (int)((double)(mapStartCoords.x << 4) * this.mapScale) + this.mapOffsetX;
        int u = 0;
        int v = 0;
        int tileSize = (int)Math.round(16.0 * this.mapScale);
        int mapWidthInTiles = 276 / tileSize;
        int mapHeightInTiles = 194 / tileSize;
        for (int x = 0; x < mapWidthInTiles + 2; ++x) {
            int screenY = this.getGuiY() + 109 + (int)((double)(mapStartCoords.y << 4) * this.mapScale) + this.mapOffsetY;
            chunkCoords.y = mapStartCoords.y;
            for (int z = 0; z < mapHeightInTiles + 2; ++z) {
                MapTile tile = tiles.get(chunkCoords);
                if (tile != null) {
                    ResourceLocation texture = BiomeTextureMap.instance().getTexture(tile);
                    if (tile.isSingleObject()) {
                        AtlasRenderHelper.drawTexturedRect(texture, screenX, screenY, 0, 0, tileSize, tileSize, tileSize * 2, tileSize * 3);
                    } else {
                        if (tile.topLeft == 1) {
                            u = 2;
                            v = 0;
                        } else if (tile.topLeft == 3) {
                            u = 0;
                            v = 4;
                        } else if (tile.topLeft == 2) {
                            u = 2;
                            v = 2;
                        } else if (tile.topLeft == 4) {
                            u = 2;
                            v = 4;
                        } else if (tile.topLeft == 0) {
                            u = 0;
                            v = 2;
                        }
                        AtlasRenderHelper.drawAutotileCorner(texture, screenX, screenY, u, v, tileSize / 2);
                        if (tile.topRight == 1) {
                            u = 3;
                            v = 0;
                        } else if (tile.topRight == 3) {
                            u = 3;
                            v = 4;
                        } else if (tile.topRight == 2) {
                            u = 1;
                            v = 2;
                        } else if (tile.topRight == 4) {
                            u = 1;
                            v = 4;
                        } else if (tile.topRight == 0) {
                            u = 3;
                            v = 2;
                        }
                        AtlasRenderHelper.drawAutotileCorner(texture, screenX + tileSize / 2, screenY, u, v, tileSize / 2);
                        if (tile.bottomLeft == 1) {
                            u = 2;
                            v = 1;
                        } else if (tile.bottomLeft == 3) {
                            u = 0;
                            v = 3;
                        } else if (tile.bottomLeft == 2) {
                            u = 2;
                            v = 5;
                        } else if (tile.bottomLeft == 4) {
                            u = 2;
                            v = 3;
                        } else if (tile.bottomLeft == 0) {
                            u = 0;
                            v = 5;
                        }
                        AtlasRenderHelper.drawAutotileCorner(texture, screenX, screenY + tileSize / 2, u, v, tileSize / 2);
                        if (tile.bottomRight == 1) {
                            u = 3;
                            v = 1;
                        } else if (tile.bottomRight == 3) {
                            u = 3;
                            v = 3;
                        } else if (tile.bottomRight == 2) {
                            u = 1;
                            v = 5;
                        } else if (tile.bottomRight == 4) {
                            u = 1;
                            v = 3;
                        } else if (tile.bottomRight == 0) {
                            u = 3;
                            v = 5;
                        }
                        AtlasRenderHelper.drawAutotileCorner(texture, screenX + tileSize / 2, screenY + tileSize / 2, u, v, tileSize / 2);
                    }
                }
                this.visibleMarkers.addAll(globalMarkers.getMarkersAtChunk(this.player.field_71093_bK, chunkCoords));
                if (localMarkers != null) {
                    this.visibleMarkers.addAll(localMarkers.getMarkersAtChunk(this.player.field_71093_bK, chunkCoords));
                }
                chunkCoords.y = (short)(chunkCoords.y + 1);
                screenY += tileSize;
            }
            chunkCoords.x = (short)(chunkCoords.x + 1);
            screenX += tileSize;
        }
        for (Marker marker : this.visibleMarkers) {
            double markerX = this.worldXToScreenX(marker.getX());
            double markerY = this.worldZToScreenY(marker.getY());
            AtlasRenderHelper.drawFullTexture(MarkerTextureMap.instance().getTexture(marker.getType()), markerX - 8.0, markerY - 8.0, 16, 16);
            if (!this.isPointInRadius((int)markerX, (int)markerY, 4, mouseX, mouseY) || marker.getLabel().length() <= 0) continue;
            this.drawTopLevelHoveringText(Arrays.asList(marker.getLabel()), mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
        GL11.glDisable((int)3089);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, this.getGuiX(), this.getGuiY(), 310, 218);
        int playerOffsetX = (int)(this.player.field_70165_t * this.mapScale) + this.mapOffsetX;
        int playerOffsetZ = (int)(this.player.field_70161_v * this.mapScale) + this.mapOffsetY;
        if (playerOffsetX < -138) {
            playerOffsetX = -138;
        }
        if (playerOffsetX > 138) {
            playerOffsetX = 138;
        }
        if (playerOffsetZ < -97) {
            playerOffsetZ = -97;
        }
        if (playerOffsetZ > 95) {
            playerOffsetZ = 95;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.isPlacingMarker ? 0.5f : 1.0f));
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.getGuiX() + 155 + playerOffsetX), (double)(this.getGuiY() + 109 + playerOffsetZ), (double)0.0);
        float playerRotation = (float)Math.round(this.player.field_70177_z / 360.0f * 16.0f) / 16.0f * 360.0f;
        GL11.glRotatef((float)(180.0f + playerRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-3.5f, (float)-4.0f, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, 7, 8);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, par3);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.isPlacingMarker) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            AtlasRenderHelper.drawFullTexture(MarkerTextureMap.instance().getTexture("red_x_large"), mouseX - 8, mouseY - 8, 16, 16);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.isExporting) {
            this.func_146276_q_();
            this.progressBar.draw((this.field_146294_l - 100) / 2, this.field_146295_m / 2 - 34);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_146281_b() {
        this.isPlacingMarker = false;
        this.markerFinalizer.close();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.field_146294_l / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.field_146295_m / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)(this.field_146294_l / 2) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)(this.field_146295_m / 2) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.isEnteringMarkerLabel = false;
            this.setInterceptKeyboard(false);
        }
    }
}

