/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.utils;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.config.configfiles.ATGBiomeConfig;

public class ATGUtils {
    public static double angleDiff(double a1, double a2) {
        double diff = a2 - a1;
        diff = (diff + Math.PI) % 360.0 - Math.PI;
        return diff;
    }

    public static boolean blockIsGround(Block block) {
        return block == Blocks.field_150348_b || block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150391_bh || block == Blocks.field_150354_m || block == Blocks.field_150435_aG || block == Blocks.field_150433_aE || block == Blocks.field_150351_n;
    }

    public static boolean blockIsGroundOrLiquid(Block block) {
        return ATGUtils.blockIsGround(block) || block == Blocks.field_150355_j || block == Blocks.field_150353_l;
    }

    public static int getTopBlockOrLiquid(World world, int x, int z) {
        Block block;
        int y;
        for (y = 255; y >= 0 && !ATGUtils.blockIsGroundOrLiquid(block = world.func_147439_a(x, y, z)); --y) {
        }
        return y;
    }

    public static int getTopBlock(World world, int x, int z) {
        Block block;
        int y;
        for (y = 255; y >= 0 && !ATGUtils.blockIsGround(block = world.func_147439_a(x, y, z)); --y) {
        }
        return y;
    }

    public static boolean blockIsNonsolidNotWater(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z).func_149662_c() && world.func_147439_a(x, y, z) != Blocks.field_150355_j;
    }

    public static double spreadRange(double n, double fulcrum, double mult, double offset) {
        return Math.max(0.0, Math.min(1.0, (n - fulcrum) * mult + fulcrum * mult + offset));
    }

    public static final long xorShift64(long a) {
        a ^= a << 21;
        a ^= a >>> 35;
        a ^= a << 4;
        return a;
    }

    public static final long coordRandom(long x, long z, long seed) {
        return ATGUtils.xorShift64(ATGUtils.xorShift64(x) + Long.rotateLeft(ATGUtils.xorShift64(z), 32)) + seed;
    }

    static class BiomeIDException
    extends RuntimeException {
        public BiomeIDException(BiomeGenBase biome1, BiomeGenBase biome2, int id) {
            super("Biome ID conflict: " + ATGBiomeConfig.getSaveNameFromBiome(biome1) + " and " + ATGBiomeConfig.getSaveNameFromBiome(biome2) + " at id " + id);
        }
    }
}

