/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.utils;

import java.awt.image.BufferedImage;

public class ATGBicubic {
    public static double cubicValue(double x, double a, double b, double c, double d) {
        return Math.min(255.0, Math.max(0.0, 0.5 * (c - a + (2.0 * a - 5.0 * b + 4.0 * c - d + (3.0 * (b - c) + d - a) * x) * x) * x + b));
    }

    public static int bicubic(BufferedImage image, double x, double y, boolean looping) {
        int a;
        int w = image.getWidth();
        int h = image.getHeight();
        if (image == null || x < 0.0 || y < 0.0 || x > (double)w || y > (double)h) {
            return -10485246;
        }
        int fx = (int)Math.floor(x);
        int fy = (int)Math.floor(y);
        double dx = x - (double)fx;
        double dy = y - (double)fy;
        int[] colours = new int[16];
        for (int iy = -1; iy < 3; ++iy) {
            for (int ix = -1; ix < 3; ++ix) {
                int cx;
                int cy = fy + iy;
                if (looping) {
                    if (cx < 0) {
                        for (cx = fx + ix; cx < 0; cx += w) {
                        }
                    } else if (cx >= w) {
                        while (cx >= w) {
                            cx -= w;
                        }
                    }
                    if (cy < 0) {
                        while (cy < 0) {
                            cy += h;
                        }
                    } else if (cy >= h) {
                        while (cy >= h) {
                            cy -= h;
                        }
                    }
                } else {
                    if (cx < 0) {
                        cx = 0;
                    } else if (cx >= w) {
                        cx = w - 1;
                    }
                    if (cy < 0) {
                        cy = 0;
                    } else if (cy >= h) {
                        cy = h - 1;
                    }
                }
                colours[(iy + 1) * 4 + (ix + 1)] = image.getRGB(cx, cy);
            }
        }
        int r = (int)Math.round(ATGBicubic.cubicValue(dy, ATGBicubic.cubicValue(dx, ATGBicubic.getRed(colours[0]), ATGBicubic.getRed(colours[1]), ATGBicubic.getRed(colours[2]), ATGBicubic.getRed(colours[3])), ATGBicubic.cubicValue(dx, ATGBicubic.getRed(colours[4]), ATGBicubic.getRed(colours[5]), ATGBicubic.getRed(colours[6]), ATGBicubic.getRed(colours[7])), ATGBicubic.cubicValue(dx, ATGBicubic.getRed(colours[8]), ATGBicubic.getRed(colours[9]), ATGBicubic.getRed(colours[10]), ATGBicubic.getRed(colours[11])), ATGBicubic.cubicValue(dx, ATGBicubic.getRed(colours[12]), ATGBicubic.getRed(colours[13]), ATGBicubic.getRed(colours[14]), ATGBicubic.getRed(colours[15]))));
        int g = (int)Math.round(ATGBicubic.cubicValue(dy, ATGBicubic.cubicValue(dx, ATGBicubic.getGreen(colours[0]), ATGBicubic.getGreen(colours[1]), ATGBicubic.getGreen(colours[2]), ATGBicubic.getGreen(colours[3])), ATGBicubic.cubicValue(dx, ATGBicubic.getGreen(colours[4]), ATGBicubic.getGreen(colours[5]), ATGBicubic.getGreen(colours[6]), ATGBicubic.getGreen(colours[7])), ATGBicubic.cubicValue(dx, ATGBicubic.getGreen(colours[8]), ATGBicubic.getGreen(colours[9]), ATGBicubic.getGreen(colours[10]), ATGBicubic.getGreen(colours[11])), ATGBicubic.cubicValue(dx, ATGBicubic.getGreen(colours[12]), ATGBicubic.getGreen(colours[13]), ATGBicubic.getGreen(colours[14]), ATGBicubic.getGreen(colours[15]))));
        int b = (int)Math.round(ATGBicubic.cubicValue(dy, ATGBicubic.cubicValue(dx, ATGBicubic.getBlue(colours[0]), ATGBicubic.getBlue(colours[1]), ATGBicubic.getBlue(colours[2]), ATGBicubic.getBlue(colours[3])), ATGBicubic.cubicValue(dx, ATGBicubic.getBlue(colours[4]), ATGBicubic.getBlue(colours[5]), ATGBicubic.getBlue(colours[6]), ATGBicubic.getBlue(colours[7])), ATGBicubic.cubicValue(dx, ATGBicubic.getBlue(colours[8]), ATGBicubic.getBlue(colours[9]), ATGBicubic.getBlue(colours[10]), ATGBicubic.getBlue(colours[11])), ATGBicubic.cubicValue(dx, ATGBicubic.getBlue(colours[12]), ATGBicubic.getBlue(colours[13]), ATGBicubic.getBlue(colours[14]), ATGBicubic.getBlue(colours[15]))));
        int out = a = (int)Math.round(ATGBicubic.cubicValue(dy, ATGBicubic.cubicValue(dx, ATGBicubic.getAlpha(colours[0]), ATGBicubic.getAlpha(colours[1]), ATGBicubic.getAlpha(colours[2]), ATGBicubic.getAlpha(colours[3])), ATGBicubic.cubicValue(dx, ATGBicubic.getAlpha(colours[4]), ATGBicubic.getAlpha(colours[5]), ATGBicubic.getAlpha(colours[6]), ATGBicubic.getAlpha(colours[7])), ATGBicubic.cubicValue(dx, ATGBicubic.getAlpha(colours[8]), ATGBicubic.getAlpha(colours[9]), ATGBicubic.getAlpha(colours[10]), ATGBicubic.getAlpha(colours[11])), ATGBicubic.cubicValue(dx, ATGBicubic.getAlpha(colours[12]), ATGBicubic.getAlpha(colours[13]), ATGBicubic.getAlpha(colours[14]), ATGBicubic.getAlpha(colours[15]))));
        out <<= 8 + r;
        out <<= 8 + g;
        out <<= 8 + b;
        return ATGBicubic.colour(r, g, b, a);
    }

    public static int getRed(int colour) {
        return colour >> 16 & 0xFF;
    }

    public static int getGreen(int colour) {
        return colour >> 8 & 0xFF;
    }

    public static int getBlue(int colour) {
        return colour & 0xFF;
    }

    public static int getAlpha(int colour) {
        return colour >> 24 & 0xFF;
    }

    public static int colour(int r, int g, int b, int a) {
        int out = a;
        out = (out << 8) + r;
        out = (out << 8) + g;
        out = (out << 8) + b;
        return out;
    }
}

