/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;

public class ATGPerlin {
    Random rand;
    double scalex;
    double scaley;
    double scalez;
    int[] permutation;

    public ATGPerlin(Random rand, double scalex, double scaley, double scalez) {
        this.rand = rand;
        this.scalex = 1.0 / scalex;
        this.scaley = 1.0 / scaley;
        this.scalez = 1.0 / scalez;
        this.permutation = new int[512];
        for (int i = 0; i < 256; ++i) {
            int n;
            this.permutation[i] = n = this.rand.nextInt(256);
            this.permutation[i + 256] = n;
        }
    }

    public ATGPerlin(Random rand, double scale) {
        this(rand, scale, scale, scale);
    }

    public ATGPerlin(Random rand) {
        this(rand, 1.0, 1.0, 1.0);
    }

    public double noise(double ix, double iy, double iz) {
        double x = ix * this.scalex;
        double y = iy * this.scaley;
        double z = iz * this.scalez;
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = ATGPerlin.fade(x);
        double v = ATGPerlin.fade(y);
        double w = ATGPerlin.fade(z);
        int A = this.permutation[X] + Y;
        int AA = this.permutation[A] + Z;
        int AB = this.permutation[A + 1] + Z;
        int B = this.permutation[X + 1] + Y;
        int BA = this.permutation[B] + Z;
        int BB = this.permutation[B + 1] + Z;
        return ATGPerlin.lerp(w, ATGPerlin.lerp(v, ATGPerlin.lerp(u, ATGPerlin.grad(this.permutation[AA], x, y, z), ATGPerlin.grad(this.permutation[BA], x - 1.0, y, z)), ATGPerlin.lerp(u, ATGPerlin.grad(this.permutation[AB], x, y - 1.0, z), ATGPerlin.grad(this.permutation[BB], x - 1.0, y - 1.0, z))), ATGPerlin.lerp(v, ATGPerlin.lerp(u, ATGPerlin.grad(this.permutation[AA + 1], x, y, z - 1.0), ATGPerlin.grad(this.permutation[BA + 1], x - 1.0, y, z - 1.0)), ATGPerlin.lerp(u, ATGPerlin.grad(this.permutation[AB + 1], x, y - 1.0, z - 1.0), ATGPerlin.grad(this.permutation[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public double normNoise(double x, double y, double z) {
        return (this.noise(x, y, z) + 1.0) * 0.49 + 0.02;
    }

    static double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    static double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }
}

