/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGPerlin;

public class ATGHeightNoise {
    long seed;
    Random rand;
    ATGPerlin[] heightNoise;
    private static final double seafix = 0.234;

    public ATGHeightNoise(long seed) {
        this.seed = seed;
        this.rand = new Random(seed * 3481348L * ((seed + 378423L) * 48592823589L) + seed * seed * seed);
        this.heightNoise = new ATGPerlin[8];
        double scale = ATGMainConfig.genModHeightScale.getDouble(1.0);
        this.heightNoise[1] = new ATGPerlin(this.rand, 256.0 * scale);
        this.heightNoise[2] = new ATGPerlin(this.rand, 2132.0 * scale);
        this.heightNoise[3] = new ATGPerlin(this.rand, 953.0 * scale);
        this.heightNoise[4] = new ATGPerlin(this.rand, 436.0 * scale);
        this.heightNoise[5] = new ATGPerlin(this.rand, 48.0 * scale);
        this.heightNoise[6] = new ATGPerlin(this.rand, 16.0 * scale);
        this.heightNoise[7] = new ATGPerlin(this.rand, 8264.0 * scale);
    }

    public double getHeight(int x, int z) {
        double h1 = this.heightNoise[1].normNoise(x, z, 0.0);
        double h2 = this.heightNoise[2].normNoise(x, z, 0.0);
        double h3 = this.heightNoise[3].normNoise(x, z, 0.0);
        double h4 = this.heightNoise[4].normNoise(x, z, 0.0);
        double d1 = this.heightNoise[5].normNoise(x, z, 0.0);
        double d2 = this.heightNoise[6].normNoise(x, z, 0.0);
        double sea = 1.0 - Math.abs(this.heightNoise[7].normNoise(x, z, 0.0) - 0.5) * 2.0;
        sea = Math.max(0.0, sea * sea - 0.8);
        double height = (h1 * h1 * h3 * h3 * 0.84 + h1 * h4 * 0.1 + d1 * 0.05 + d2 * 0.01) * 2.8 - 0.08;
        if (height < 0.4) {
            double factor = Math.max(0.0, 1.0 - height - 0.6);
            height = height * (1.0 - factor) + (h2 - 0.04) * factor;
        }
        if ((height -= sea * 0.4) < 0.234) {
            double diff = 0.234 - height;
            height = 0.234 - diff * 0.6;
        }
        return height;
    }

    public int getHeightInt(int x, int z) {
        return 1 + (int)(this.getHeight(x, z) * 254.0);
    }

    public double getInland(int x, int z) {
        return this.heightNoise[2].normNoise(x, z, 0.0);
    }

    public double getImageNoise(int x, int z) {
        return this.heightNoise[4].normNoise(x, z, 0.0) * 0.5 + this.heightNoise[5].normNoise(x, z, 0.0) * 0.35 + this.heightNoise[6].normNoise(x, z, 0.0) * 0.15;
    }

    public static int getInt(double height) {
        return 1 + (int)(height * 254.0);
    }
}

