/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.gen.ATGGenLayerSourceImage;
import ttftcuts.atg.gen.ATGPerlin;
import ttftcuts.atg.utils.ATGBicubic;

public class ATGGenLayerTemperature
extends ATGGenLayer {
    private Random rand;
    private ATGPerlin[] tempNoise;
    private ATGGenLayer height;
    private ATGGenLayer inland;
    private ATGGenLayerSourceImage image;
    private double climateOffset;
    private double offset;
    private double multiplier;

    public ATGGenLayerTemperature(Long seed, ATGGenLayer height, ATGGenLayer inland, ATGGenLayerSourceImage image) {
        super(seed);
        this.height = height;
        this.inland = inland;
        this.image = image;
        this.offset = ATGMainConfig.genModTemp.getDouble(0.0);
        this.multiplier = ATGMainConfig.genModTempMult.getDouble(1.0);
        this.func_75903_a(seed * 197376485L + 435567256165L, seed * 4645788735624L + 49485237494L);
        this.rand = new Random((long)this.func_75902_a(1000000000) * seed);
        double scale = ATGMainConfig.genModTempScale.getDouble(1.0);
        this.tempNoise = new ATGPerlin[5];
        this.tempNoise[1] = new ATGPerlin(this.rand, 1281.0 * scale);
        this.tempNoise[2] = new ATGPerlin(this.rand, 119.0 * scale);
        this.tempNoise[3] = new ATGPerlin(this.rand, 26.0 * scale);
        this.tempNoise[4] = new ATGPerlin(this.rand, 3.0 * scale);
        this.climateOffset = this.rand.nextDouble();
    }

    private double getTemperature(int x, int z) {
        double height = (double)this.height.getInt(x, z) * 0.00390625;
        double inland = (double)this.inland.getInt(x, z) * 0.00390625;
        double inlandfactor = Math.max(0.0, inland - 0.5);
        double heightfactor = Math.max(0.0, height * 2.0 - 0.9);
        double t1 = this.tempNoise[1].normNoise(x, z, 0.0);
        double t2 = this.tempNoise[2].normNoise(x, z, 0.0);
        double t3 = this.tempNoise[3].normNoise(x, z, 0.0);
        double mix = (t1 * 0.87 + t2 * 0.07 + t3 * 0.06) * 1.3 - 0.2;
        double temp = Math.max(0.0, mix + inlandfactor * 0.5 - heightfactor * 0.85);
        if (ATGMainConfig.useClimate.getBoolean(false)) {
            int mode = ATGMainConfig.climateType.getInt(0);
            if (mode > 2 || mode < 0) {
                mode = 0;
            }
            double min = ATGMainConfig.climateMin.getDouble(0.0);
            double max = ATGMainConfig.climateMax.getDouble(1.0);
            int period = ATGMainConfig.climatePeriod.getInt(5000);
            double range = max - min;
            double pos = (double)(z % period) / (double)period;
            if (mode != 0) {
                pos = (double)z / (double)period;
            }
            pos = ATGMainConfig.climateCentre.getBoolean(false) ? (mode == 2 ? (pos += 0.5) : (pos += 0.25)) : (pos += this.climateOffset);
            if (mode == 0) {
                temp = (Math.sin(Math.PI * 2 * pos) + (temp - 0.5) * 0.2) * range + min;
            } else if (mode == 1) {
                pos = Math.max(0.0, Math.min(1.0, pos));
                temp = (-Math.cos(Math.PI * 2 * pos) + (temp - 0.5) * 0.2) * range + min;
            } else if (mode == 2) {
                pos = Math.max(0.0, Math.min(1.0, pos));
                temp = (-Math.cos(Math.PI * pos) + (temp - 0.5) * 0.2) * range + min;
            }
        }
        if (ATGMainConfig.useImageMap.getBoolean(false)) {
            int imageinfo = this.image.getInt(x, z);
            double a = (double)ATGBicubic.getAlpha(imageinfo) / 255.0;
            double green = (double)ATGBicubic.getGreen(imageinfo) / 255.0;
            if (a > 0.0 && green > 0.0) {
                temp = temp * (1.0 - a) + green * a;
            }
        }
        return temp * this.multiplier + this.offset;
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                this.func_75903_a(x + dx, z + dz);
                int X = x + dx;
                int Z = z + dz;
                double temp = this.getTemperature(X, Z);
                data[dx + dz * w] = 1 + (int)(temp * 255.0);
            }
        }
        return data;
    }

    @Override
    public int getInt(int x, int z) {
        return 1 + (int)(this.getTemperature(x, z) * 255.0);
    }

    @Override
    public double getDouble(int x, int z) {
        return this.getTemperature(x, z);
    }
}

