/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.gen.ATGGenLayerInland;
import ttftcuts.atg.gen.ATGGenLayerRarity;
import ttftcuts.atg.gen.ATGGenLayerSourceImage;
import ttftcuts.atg.gen.ATGGenModPlateau;
import ttftcuts.atg.gen.ATGHeightNoise;
import ttftcuts.atg.utils.ATGBicubic;

public class ATGGenLayerHeight
extends ATGGenLayer {
    private Random rand;
    private ATGGenLayerInland inland;
    private ATGGenLayerRarity rarity;
    private ATGGenLayerSourceImage image;
    private ATGHeightNoise heightNoise;
    private double offset;
    private double multiplier;

    public ATGGenLayerHeight(Long seed, ATGGenLayerInland inland, ATGGenLayerRarity rarity, ATGGenLayerSourceImage image) {
        super(seed);
        this.func_75903_a(seed * 3744824524L + 38149085244241L, seed * 79818951L + 51498718L);
        this.inland = inland;
        this.rarity = rarity;
        this.image = image;
        this.heightNoise = this.inland.getNoise();
        this.offset = ATGMainConfig.genModHeight.getDouble(0.0);
        this.multiplier = ATGMainConfig.genModHeightMult.getDouble(1.0);
    }

    private double getHeight(int x, int z) {
        double h = this.heightNoise.getHeight(x, z);
        double r = this.rarity.getDouble(x, z);
        if (r >= 0.375) {
            double factor = Math.min(1.0, (r - 0.375) * 12.0);
            double out = h;
            if (h >= 0.3333333333333333 && h <= 0.43137254901960786) {
                out = (double)ATGGenModPlateau.plateau((int)(h * 255.0), this.rand, h, 85, 100, 110, 3.0, true) / 255.0;
            }
            if (h >= 0.47058823529411764 && h <= 0.5686274509803921) {
                out = (double)ATGGenModPlateau.plateau((int)(h * 255.0), this.rand, h, 120, 140, 145, 3.0, true) / 255.0;
            }
            h = h * (1.0 - factor) + out * factor;
        }
        if (ATGMainConfig.useImageMap.getBoolean(false)) {
            int imageinfo = this.image.getInt(x, z);
            double a = (double)ATGBicubic.getAlpha(imageinfo) / 255.0;
            double red = (double)ATGBicubic.getRed(imageinfo) / 255.0;
            double imagenoise = this.heightNoise.getImageNoise(x, z) - 0.5;
            if (a > 0.0 && red > 0.0) {
                h = h * (1.0 - a) + (red + imagenoise * 0.03) * a;
            }
        }
        return Math.max(0.005, h * this.multiplier + this.offset);
    }

    @Override
    public double getDouble(int x, int z) {
        return this.getHeight(x, z);
    }

    @Override
    public int getInt(int x, int y) {
        return 1 + (int)(this.getHeight(x, y) * 254.0);
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                this.func_75903_a(x + dx, z + dz);
                int X = x + dx;
                int Z = z + dz;
                double height = this.getHeight(X, Z);
                data[dx + dz * w] = 1 + (int)(height * 254.0);
                if (data[dx + dz * w] != 1) continue;
                System.out.println("################## MISSING HEIGHT AT " + X + "," + Z);
            }
        }
        return data;
    }
}

