/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.MinecraftForge;
import ttftcuts.atg.api.events.listenable.ATGBiomeGroupAssignmentEvent;
import ttftcuts.atg.biome.ATGBiomeGroup;
import ttftcuts.atg.biome.ATGBiomeSortable;
import ttftcuts.atg.config.ATGBiomeList;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.utils.ATGUtils;

public class ATGGenLayerBiomes
extends ATGGenLayer {
    protected ATGGenLayer height;
    protected ATGGenLayer temp;
    protected ATGGenLayer moisture;
    protected ATGGenLayer inland;
    protected ATGGenLayer rarity;
    protected GenLayer blob;
    protected Random random;
    protected Random fuzz;
    private int[] layerCache;
    private int blobval;
    private int sealevel;
    private double seadouble;
    private double sealimit;
    private double landlimit;

    public ATGGenLayerBiomes(long seed, ATGGenLayer height, ATGGenLayer temp, ATGGenLayer moisture, ATGGenLayer inland, ATGGenLayer rarity, GenLayer blob) {
        super(seed);
        this.height = height;
        this.temp = temp;
        this.moisture = moisture;
        this.inland = inland;
        this.rarity = rarity;
        this.sealevel = ATGMainConfig.genModSeaLevel.getInt(63);
        this.seadouble = (double)(this.sealevel + 1) / 256.0;
        this.sealimit = this.seadouble - 0.02;
        this.landlimit = this.seadouble + 0.001;
        this.blob = blob;
        this.random = new Random(seed);
        this.fuzz = new Random(0L);
        this.layerCache = new int[32768];
        this.blobval = 0;
    }

    private double getFuzz(int x, int z, int salt) {
        double out = 0.0;
        int ox = 3847234;
        int oz = 8362482;
        long xm = x * ox;
        long zm = z * oz;
        this.fuzz.setSeed((xm ^ zm) + (long)salt);
        out += this.fuzz.nextDouble();
        this.fuzz.setSeed((xm + (long)ox ^ zm) + (long)salt);
        out += this.fuzz.nextDouble();
        this.fuzz.setSeed((xm - (long)ox ^ zm) + (long)salt);
        out += this.fuzz.nextDouble();
        this.fuzz.setSeed((xm ^ zm + (long)oz) + (long)salt);
        out += this.fuzz.nextDouble();
        this.fuzz.setSeed((xm ^ zm - (long)oz) + (long)salt);
        return (out += this.fuzz.nextDouble()) * 0.2 - 0.5;
    }

    private double getFertility(double temp, double moisture, double height) {
        return Math.max(0.0, moisture * 1.15 - Math.abs(temp - 0.65) - (height - 0.5));
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] heightData = this.height.func_75904_a(x, z, w, h);
        int[] tempData = this.temp.func_75904_a(x, z, w, h);
        int[] moistureData = this.moisture.func_75904_a(x, z, w, h);
        int[] inlandData = this.inland.func_75904_a(x, z, w, h);
        int[] data = this.layerCache;
        ArrayList<ATGBiomeGroup> biomeset = new ArrayList<ATGBiomeGroup>();
        ArrayList<ATGBiomeSortable> suitables = new ArrayList<ATGBiomeSortable>();
        ATGBiomeGroup finalgroup = null;
        ATGBiomeGroup eventgroup = null;
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                int pos = dx + dz * w;
                double height = (double)heightData[pos] * 0.00390625;
                double temp = ((double)tempData[pos] + this.getFuzz(x + dx, z + dz, 345) * 6.0) * 0.00390625;
                if (!ATGMainConfig.useClimate.getBoolean(false)) {
                    temp = ATGUtils.spreadRange(temp, 0.4, 1.5, -0.15);
                }
                double moisture = ((double)moistureData[pos] + this.getFuzz(x + dx, z + dz, 103) * 4.0) * 0.00390625;
                moisture = ATGUtils.spreadRange(moisture, 0.4, 1.5, 0.07);
                double inland = (double)inlandData[pos] * 0.00390625;
                int biome = BiomeGenBase.field_76772_c.field_76756_M;
                double fertility = this.getFertility(temp += Math.max(0.0, inland - 0.5), moisture -= Math.max(0.0, inland - 0.5), height);
                if (ATGBiomeList.volcano.isPresent() && height >= MathHelper.func_82716_a((Random)this.random, (double)0.973, (double)0.982)) {
                    biome = ((BiomeGenBase)ATGBiomeList.volcano.get()).field_76756_M;
                } else {
                    biomeset.clear();
                    double heightFuzz = this.getFuzz(x + dx, z + dz, 345) * 0.00390625;
                    if (height - heightFuzz * 0.5 < this.sealimit) {
                        biomeset.addAll(ATGBiomeManager.sea().values());
                        biome = BiomeGenBase.field_76771_b.field_76756_M;
                    } else if (height < this.landlimit) {
                        biomeset.addAll(ATGBiomeManager.coast().values());
                        biome = BiomeGenBase.field_76787_r.field_76756_M;
                    } else {
                        biomeset.addAll(ATGBiomeManager.land().values());
                        biome = BiomeGenBase.field_76772_c.field_76756_M;
                    }
                    suitables.clear();
                    if (!biomeset.isEmpty()) {
                        for (int i = 0; i < biomeset.size(); ++i) {
                            ATGBiomeGroup b = (ATGBiomeGroup)biomeset.get(i);
                            b.process();
                            if (b == null || b.getCount() == 0 || !b.generate || height + heightFuzz > b.maxHeight || height + heightFuzz < b.minHeight) continue;
                            double bh = b.height;
                            double bt = b.temp;
                            double bm = b.rainfall;
                            bt = ATGUtils.spreadRange(bt, 0.4, 1.3, -0.3);
                            bm = ATGUtils.spreadRange(bm, 0.4, 1.2, 0.07);
                            double bf = this.getFertility(bt, bm, bh);
                            double dt = 1.0 - Math.abs(temp - bt);
                            double dm = 1.0 - Math.abs(moisture - bm);
                            double df = 1.0 - Math.abs(fertility - bf);
                            double suitability = b.suitability + df * 0.5 + dt + dm;
                            suitables.add(new ATGBiomeSortable(b, suitability));
                        }
                        Collections.sort(suitables);
                        if (suitables.size() > 0) {
                            finalgroup = ((ATGBiomeSortable)suitables.get((int)0)).biomegroup;
                            if (ATGBiomeManager.sendGroupAssignmentEvents) {
                                ATGBiomeGroupAssignmentEvent event = new ATGBiomeGroupAssignmentEvent(x + dx, z + dz, height, temp, moisture, finalgroup.name);
                                MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
                                if (event.modified) {
                                    eventgroup = ATGBiomeManager.getGroupFromName(event.group);
                                    eventgroup.process();
                                    if (eventgroup != null && eventgroup.getCount() > 0) {
                                        finalgroup = eventgroup;
                                    }
                                }
                            }
                            this.blobval = this.blob.func_75904_a(x + dx + finalgroup.ox, z + dz + finalgroup.oz, 1, 1)[0];
                            try {
                                biome = finalgroup.getBiome((int)this.blobval).field_76756_M;
                            }
                            catch (NullPointerException e) {
                                System.out.println("ATG: Something went wrong when getting the biome at " + (x + dx) + "," + (z + dz) + " from the " + finalgroup.name + " group:");
                                e.printStackTrace();
                            }
                            ((ATGBiomeSortable)suitables.get((int)0)).biomegroup = null;
                            finalgroup = null;
                            eventgroup = null;
                        }
                    }
                }
                data[pos] = biome;
            }
        }
        biomeset.clear();
        suitables.clear();
        biomeset = null;
        suitables = null;
        return data;
    }

    @Override
    public int getInt(int x, int z) {
        return this.func_75904_a(x, z, 1, 1)[0];
    }

    @Override
    public double getDouble(int x, int z) {
        return 0.0;
    }
}

