/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.feature;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import ttftcuts.atg.utils.ATGUtils;

public class ATGWorldGenForestClearing
implements IWorldGenerator {
    private static final int searchRangeHeight = 5;
    private World w;
    private int converted = 0;
    private static final int leafRange = 3;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int dz;
        int z;
        if (world.field_73011_w.field_76577_b.func_77127_a() != "ATG") {
            return;
        }
        if (world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (random.nextInt(1000) >= 25) {
            return;
        }
        this.w = world;
        int dx = random.nextInt(16);
        int x = chunkX * 16 + dx;
        int y = ATGUtils.getTopBlockOrLiquid(this.w, x, z = chunkZ * 16 + (dz = random.nextInt(16)));
        if (y <= 63) {
            return;
        }
        BiomeGenBase biome = this.w.func_72807_a(x, z);
        if (biome.field_76760_I.field_76832_z < 4) {
            return;
        }
        double rad = 5.0 + random.nextDouble() * 10.0;
        this.converted = 0;
        System.out.println("Clearing generating at X=" + x + ", Z=" + z);
        this.makeClearing(x, z, rad);
        int children = random.nextInt(6);
        for (int i = 0; i < children; ++i) {
            double ang = random.nextDouble() * Math.PI * 2.0;
            int cx = (int)Math.round(Math.sin(ang) * rad);
            int cz = (int)Math.round(Math.cos(ang) * rad);
            double crad = 2.0 + random.nextDouble() * (rad / 3.0);
            this.makeClearing(x + cx, z + cz, crad);
        }
        System.out.println("Removed " + this.converted + " trees!");
    }

    private void makeClearing(int x, int z, double radius) {
        int width = (int)Math.ceil(radius);
        int y = ATGUtils.getTopBlockOrLiquid(this.w, x, z);
        for (int dx = 0; dx < width * 2; ++dx) {
            for (int dz = 0; dz < width * 2; ++dz) {
                int ix = x - width + dx;
                int iz = z - width + dz;
                int rx = dx - width;
                int rz = dz - width;
                if (!(Math.sqrt(rx * rx + rz * rz) <= radius)) continue;
                for (int dy = 0; dy < 10; ++dy) {
                    int iy = y + 5 - dy;
                    Block block = this.w.func_147439_a(ix, iy, iz);
                    if (block != Blocks.field_150364_r || this.w.func_147439_a(ix, iy + 1, iz) != Blocks.field_150364_r || this.w.func_147439_a(ix, iy - 1, iz) != Blocks.field_150346_d && this.w.func_147439_a(ix, iy - 1, iz) != Blocks.field_150349_c) continue;
                    this.removeTree(ix, iy, iz);
                    ++this.converted;
                }
            }
        }
    }

    private void removeTree(int x, int y, int z) {
        this.removeTreeSection(x, y, z);
        this.w.func_147449_b(x, y, z, Blocks.field_150426_aN);
    }

    private void removeTreeSection(int x, int y, int z) {
        Block id = this.w.func_147439_a(x, y, z);
        if (id == Blocks.field_150364_r) {
            this.w.func_147449_b(x, y, z, Blocks.field_150350_a);
            for (int dx = -3; dx <= 3; ++dx) {
                for (int dz = -3; dz <= 3; ++dz) {
                    for (int dy = -3; dy <= 3; ++dy) {
                        if (dx == 0 && dy == 0 && dz == 0 || this.w.func_147439_a(x + dx, y + dy, z + dz) != Blocks.field_150362_t) continue;
                        this.removeLeaves(x + dx, y + dy, z + dz);
                    }
                }
            }
            this.removeTreeSection(x - 1, y, z - 1);
            this.removeTreeSection(x - 1, y, z);
            this.removeTreeSection(x - 1, y, z + 1);
            this.removeTreeSection(x + 1, y, z - 1);
            this.removeTreeSection(x + 1, y, z);
            this.removeTreeSection(x + 1, y, z + 1);
            this.removeTreeSection(x, y, z - 1);
            this.removeTreeSection(x, y, z + 1);
            this.removeTreeSection(x, y + 1, z);
            this.removeTreeSection(x - 1, y + 1, z - 1);
            this.removeTreeSection(x - 1, y + 1, z);
            this.removeTreeSection(x - 1, y + 1, z + 1);
            this.removeTreeSection(x + 1, y + 1, z - 1);
            this.removeTreeSection(x + 1, y + 1, z);
            this.removeTreeSection(x + 1, y + 1, z + 1);
            this.removeTreeSection(x, y + 1, z - 1);
            this.removeTreeSection(x, y + 1, z + 1);
        }
    }

    private void removeLeaves(int x, int y, int z) {
        boolean remove = true;
        for (int dx = -3; dx <= 3; ++dx) {
            block1: for (int dz = -3; dz <= 3; ++dz) {
                for (int dy = -3; dy <= 3; ++dy) {
                    if (dx == 0 && dy == 0 && dz == 0 || this.w.func_147439_a(x + dx, y + dy, z + dz) != Blocks.field_150364_r) continue;
                    remove = false;
                    continue block1;
                }
            }
        }
        if (remove) {
            this.w.func_147468_f(x, y, z);
        }
    }
}

