/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import ttftcuts.atg.ATGChunkManager;
import ttftcuts.atg.config.ATGBiomeList;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGPerlin;
import ttftcuts.atg.structure.ATGMapGenRiver;

public class ATGChunkProvider
implements IChunkProvider {
    private World worldObj;
    private Random rand;
    private boolean useStructures;
    public long seed;
    private int sealevel;
    private ATGChunkManager manager;
    private BiomeGenBase[] biomesForGeneration;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private ATGMapGenRiver riverGenerator;
    private ATGPerlin[] noise;

    public ATGChunkProvider(World world, long seedNum, boolean structures) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.riverGenerator = new ATGMapGenRiver();
        this.worldObj = world;
        this.seed = seedNum;
        this.useStructures = structures;
        this.rand = new Random(this.seed);
        this.sealevel = ATGMainConfig.genModSeaLevel.getInt(63);
        this.manager = (ATGChunkManager)this.worldObj.func_72959_q();
        this.noise = new ATGPerlin[20];
        this.noise[0] = new ATGPerlin(this.rand, 100.0, 10.0, 100.0);
        this.noise[1] = new ATGPerlin(this.rand, 200.0, 20.0, 200.0);
        this.noise[2] = new ATGPerlin(this.rand, 300.0, 30.0, 300.0);
        this.noise[3] = new ATGPerlin(this.rand, 400.0, 40.0, 400.0);
        this.noise[4] = new ATGPerlin(this.rand, 128.0, 128.0, 128.0);
        this.noise[5] = new ATGPerlin(this.rand, 64.0, 64.0, 64.0);
        this.noise[6] = new ATGPerlin(this.rand, 32.0, 32.0, 32.0);
        this.noise[7] = new ATGPerlin(this.rand, 16.0, 16.0, 16.0);
        this.noise[8] = new ATGPerlin(this.rand, 64.0, 64.0, 64.0);
        this.noise[9] = new ATGPerlin(this.rand, 20.0, 1.0, 20.0);
    }

    public ATGChunkManager getManager() {
        return this.manager;
    }

    private double[] getNoiseMix(int x, int y, int z) {
        int noiseHeight = 16;
        double[] data = new double[noiseHeight];
        for (int dy = 0; dy < noiseHeight; ++dy) {
            int ny = y + dy - noiseHeight / 2;
            double n1 = this.noise[0].noise(x, ny, z);
            double n2 = this.noise[1].noise(x, ny, z);
            double n3 = this.noise[2].noise(x, ny, z);
            double n4 = this.noise[3].noise(x, ny, z);
            double n5 = this.noise[4].noise(x, ny, z);
            double n6 = this.noise[5].noise(x, ny, z);
            double n7 = this.noise[6].noise(x, ny, z);
            double n8 = this.noise[7].noise(x, ny, z);
            double nc1 = (n1 * 5.0 + n2 * 3.0 + n3 + n4) * 0.1;
            double nc2 = (n5 * 3.0 + n6 * 13.0 + n7 * 3.0 + n8) * 0.05;
            data[dy] = (nc1 + nc2 * 3.0) * 0.25;
        }
        return data;
    }

    public ATGPerlin getNoiseGen(int id) {
        if (id < 0 || id >= this.noise.length) {
            id = 0;
        }
        return this.noise[id];
    }

    private void generateTerrain(int chunkX, int chunkY, Block[] data) {
        int height = data.length / 256;
        int[] rawdata = this.manager.getRawGenInts(chunkX * 16, chunkY * 16, 16, 16);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int gen = rawdata[x + z * 16];
                double[] noiseData = this.getNoiseMix(chunkX * 16 + x, gen, chunkY * 16 + z);
                int noiseHeight = noiseData.length;
                int biome = this.manager.func_76935_a((int)(chunkX * 16 + x), (int)(chunkY * 16 + z)).field_76756_M;
                double biomeNoiseFactor = 1.0;
                if (ATGBiomeManager.getMod(biome) != null) {
                    gen = ATGBiomeManager.getMod(biome).modify(this.worldObj, gen, this.rand, this.manager.getRawHeightDouble(chunkX * 16 + x, chunkY * 16 + z), chunkX * 16 + x, chunkY * 16 + z);
                    biomeNoiseFactor = ATGBiomeManager.getMod(biome).noiseFactor();
                }
                for (int y = 0; y < height; ++y) {
                    Block block = Blocks.field_150350_a;
                    double density = gen - y;
                    if ((double)y >= (double)gen - (double)noiseHeight * 0.5 && y < gen + noiseHeight / 2) {
                        double diff = 1.0 - (double)Math.abs(gen - y) / ((double)noiseHeight * 0.5);
                        double factor = diff * diff * (3.0 - 2.0 * diff);
                        double heightfactor = Math.min(1.5, (double)Math.max(0, y - (this.sealevel + 12)) / 60.0);
                        density += (noiseData[y - gen + noiseHeight / 2] * 255.0 * factor * heightfactor * heightfactor - 0.25) * biomeNoiseFactor;
                    }
                    if (y < 255) {
                        if (density > 0.0) {
                            block = ATGBiomeList.volcano.isPresent() && biome == ((BiomeGenBase)ATGBiomeList.volcano.get()).field_76756_M && y < gen - 1 && gen <= 231 ? Blocks.field_150343_Z : Blocks.field_150348_b;
                        } else if (ATGBiomeList.volcano.isPresent() && biome == ((BiomeGenBase)ATGBiomeList.volcano.get()).field_76756_M && y < 226) {
                            block = ATGMainConfig.genMagmaShafts.getBoolean(true) ? Blocks.field_150353_l : Blocks.field_150347_e;
                        } else if (y < this.sealevel) {
                            block = Blocks.field_150355_j;
                        }
                    }
                    data[x << 12 | z << 8 | y] = block;
                }
            }
        }
    }

    public Chunk func_73154_d(int chunkX, int chunkY) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkY * 132897987541L);
        Block[] data = new Block[65536];
        byte[] abyte = new byte[65536];
        this.generateTerrain(chunkX, chunkY, data);
        this.biomesForGeneration = this.manager.func_76933_b(this.biomesForGeneration, chunkX * 16, chunkY * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkY, data, abyte, this.biomesForGeneration);
        if (ATGMainConfig.genRivers.getBoolean(true)) {
            this.riverGenerator.func_151539_a(this, this.worldObj, chunkX, chunkY, data);
        }
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        if (this.useStructures) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkY, data);
        }
        Chunk chunk = new Chunk(this.worldObj, data, abyte, chunkX, chunkY);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public Chunk func_73158_c(int var1, int var2) {
        return this.func_73154_d(var1, var2);
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] blocks, byte[] abyte, BiomeGenBase[] biomes) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, par1, par2, blocks, biomes);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        byte var5 = (byte)this.sealevel;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                BiomeGenBase var10 = biomes[var9 + var8 * 16];
                int var12 = (int)(this.noise[8].noise(par1 * 16 + var9, 1.0, par2 * 16 + var8) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = var10.field_76752_A;
                Block var15 = var10.field_76753_B;
                for (int var16 = 255; var16 >= 0; --var16) {
                    int var17 = (var9 * 16 + var8) * 256 + var16;
                    float var11 = var10.func_150564_a(par1 * 16 + var9, var16, par2 * 16 + var8);
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        blocks[var17] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var18 = blocks[var17];
                    if (var18 == Blocks.field_150350_a) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != Blocks.field_150348_b) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var15 = Blocks.field_150348_b;
                        } else if (var16 >= var5 - 4 && var16 <= var5 + 1) {
                            var14 = var10.field_76752_A;
                            var15 = var10.field_76753_B;
                        }
                        if (var16 < var5 && var14 == Blocks.field_150350_a) {
                            var14 = var11 < 0.15f ? Blocks.field_150432_aD : Blocks.field_150355_j;
                        }
                        var13 = var12;
                        if (var16 >= var5 - 1) {
                            blocks[var17] = var14;
                            continue;
                        }
                        blocks[var17] = var15;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    blocks[var17] = var15;
                    if (--var13 != 0 || var15 != Blocks.field_150354_m) continue;
                    var13 = this.rand.nextInt(4);
                    var15 = Blocks.field_150322_A;
                }
            }
        }
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int chunkX, int chunkZ) {
        int popZ;
        int popY;
        int popX;
        BlockSand.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BiomeGenBase biome = this.worldObj.func_72807_a(x + 16, z + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long rand1 = this.rand.nextLong() / 2L * 2L + 1L;
        long rand2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * rand1 + (long)chunkZ * rand2 ^ this.worldObj.func_72905_C());
        boolean hasVillage = false;
        if (ATGMainConfig.genRivers.getBoolean(true)) {
            this.riverGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillage));
        if (this.useStructures) {
            this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            hasVillage = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
            this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE) && !hasVillage && this.rand.nextInt(4) == 0) {
            popX = x + this.rand.nextInt(16) + 8;
            popY = this.rand.nextInt(256);
            popZ = z + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, popX, popY, popZ);
        }
        if (TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) && !hasVillage && this.rand.nextInt(8) == 0) {
            popX = x + this.rand.nextInt(16) + 8;
            popY = this.rand.nextInt(this.rand.nextInt(248) + 8);
            popZ = z + this.rand.nextInt(16) + 8;
            if (popY < this.sealevel || this.rand.nextInt(10) == 0) {
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, popX, popY, popZ);
            }
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (int i = 0; doGen && i < 8; ++i) {
            popX = x + this.rand.nextInt(16) + 8;
            if (!new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, popX, popY = this.rand.nextInt(256), popZ = z + this.rand.nextInt(16) + 8)) continue;
        }
        biome.func_76728_a(this.worldObj, this.rand, x, z);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        x += 8;
        z += 8;
        doGen = TerrainGen.populate((IChunkProvider)par1IChunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (popX = 0; doGen && popX < 16; ++popX) {
            for (popZ = 0; popZ < 16; ++popZ) {
                popY = this.worldObj.func_72874_g(x + popX, z + popZ);
                if (this.worldObj.func_72884_u(popX + x, popY - 1, popZ + z)) {
                    this.worldObj.func_147449_b(popX + x, popY - 1, popZ + z, Blocks.field_150432_aD);
                }
                if (!this.worldObj.func_147478_e(popX + x, popY, popZ + z, true)) continue;
                this.worldObj.func_147449_b(popX + x, popY, popZ + z, Blocks.field_150431_aC);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, hasVillage));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean var1, IProgressUpdate var2) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "ATGLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase var5 = this.worldObj.func_72807_a(par2, par4);
        return var5 == null ? null : (var5 == BiomeGenBase.field_76780_h && par1EnumCreatureType == EnumCreatureType.monster && this.scatteredFeatureGenerator.func_75048_a(par2, par3, par4) ? this.scatteredFeatureGenerator.func_82667_a() : var5.func_76747_a(par1EnumCreatureType));
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return "Stronghold".equals(p_147416_2_) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(p_147416_1_, p_147416_3_, p_147416_4_, p_147416_5_) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        if (this.useStructures) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        }
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }
}

