/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import ttftcuts.atg.ATGWorldType;
import ttftcuts.atg.compatibility.ATGModCompatibility;
import ttftcuts.atg.config.ATGBiomeList;
import ttftcuts.atg.config.configfiles.ATGConfigFiles;
import ttftcuts.atg.config.configfiles.ATGMainConfig;
import ttftcuts.atg.eventhandlers.ATGAPIEventHandler;
import ttftcuts.atg.feature.ATGWorldGenCliffs;
import ttftcuts.atg.feature.ATGWorldGenRocks;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGWorldGenHighAltitudeOres;
import ttftcuts.atg.gen.ATGWorldGenHighAltitudePockets;
import ttftcuts.atg.structure.ATGComponentRiverSection;
import ttftcuts.atg.structure.ATGStructureRiverStart;

@Mod(modid="ATG", name="Alternate Terrain Generation", version="0.10.0")
public class ATG {
    public static ATGWorldGenRocks rockGen = new ATGWorldGenRocks();
    public static ATGWorldGenCliffs cliffGen = new ATGWorldGenCliffs();
    public static ATGWorldGenHighAltitudeOres highOreGen = new ATGWorldGenHighAltitudeOres();
    public static ATGWorldGenHighAltitudePockets highPocketGen = new ATGWorldGenHighAltitudePockets();
    public static ATGBiomeManager biomeManager = new ATGBiomeManager();
    @Mod.Instance(value="ATG")
    public static ATG instance;
    public static ATGWorldType atgWorldType;
    public static String configPath;
    public static String mapPath;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configPath = event.getModConfigurationDirectory() + "/atg/";
        mapPath = configPath + "maps/";
        File maps = new File(mapPath);
        if (!maps.exists()) {
            maps.mkdir();
        }
        ATGConfigFiles.init(configPath);
        atgWorldType = new ATGWorldType(ATGMainConfig.ATGWorldID.getInt(9));
        ATGBiomeList.init();
        if (ATGMainConfig.genRocks.getBoolean(true)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)rockGen, (int)1);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)cliffGen, (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)highPocketGen, (int)1);
        if (ATGMainConfig.genHighAltitudeOres.getBoolean(true)) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)highOreGen, (int)1);
        }
        MinecraftForge.EVENT_BUS.register((Object)new ATGAPIEventHandler());
        MapGenStructureIO.func_143034_b(ATGStructureRiverStart.class, (String)"ATGRiver");
        MapGenStructureIO.func_143031_a(ATGComponentRiverSection.class, (String)"ATGRiverSection");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ATGConfigFiles.postInit();
        ATGModCompatibility.init();
    }

    public static boolean isATG(World world) {
        return world.field_73011_w.field_76577_b.func_77127_a() == "ATG" && world.field_73011_w.field_76574_g == 0;
    }
}

