/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.utils.ATGUtils;

public class ATGGenLayerBlobs
extends ATGGenLayer {
    protected Random blob = new Random(0L);
    protected long salt = 9348712385L;
    public static final int biomebits = 16;
    public static final int subbits = 14;
    public static final int granularity = (int)Math.pow(2.0, 16.0) - 1;
    public static final int subgranularity = (int)Math.pow(2.0, 14.0) - 1;

    public ATGGenLayerBlobs(long seed) {
        super(seed);
    }

    private int getBlob(int x, int z) {
        this.blob.setSeed(ATGUtils.coordRandom(x, z, this.seed));
        return this.blob.nextInt(granularity);
    }

    @Override
    public int getInt(int x, int z) {
        return this.getBlob(x, z);
    }

    @Override
    public double getDouble(int x, int z) {
        return this.getBlob(x, z);
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                data[dx + dz * w] = this.getBlob(x + dx, z + dz);
            }
        }
        return data;
    }
}

