/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.feature;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenShrub;
import ttftcuts.atg.ATG;

public class ATGWorldGenRocks
implements IWorldGenerator {
    public static final int rocksPerChunk = 1;
    public static final int rockChance = 40;
    public static final int bigRockChance = 50;
    public static int[] rocksPerChunkBiome = new int[256];
    public static int[] rockChanceBiome = new int[256];
    public static int[] bigRockChanceBiome = new int[256];

    public static void setRockValues(BiomeGenBase biome, int rChance, int rLargeChance, int rpc) {
        ATGWorldGenRocks.rocksPerChunkBiome[biome.field_76756_M] = rpc;
        ATGWorldGenRocks.rockChanceBiome[biome.field_76756_M] = rChance;
        ATGWorldGenRocks.bigRockChanceBiome[biome.field_76756_M] = rLargeChance;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!ATG.isATG(world)) {
            return;
        }
        int rocksNum = 1;
        int chance = 40;
        int bigChance = 50;
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_72825_h(x, z);
        int biome = world.func_72807_a((int)x, (int)z).field_76756_M;
        if (rocksPerChunkBiome[biome] != 0) {
            rocksNum = rocksPerChunkBiome[biome];
        }
        if (rockChanceBiome[biome] != 0) {
            chance = rockChanceBiome[biome];
        }
        if (bigRockChanceBiome[biome] != 0) {
            bigChance = bigRockChanceBiome[biome];
        }
        if (rocksNum == 0 || chance == 0) {
            return;
        }
        if (random.nextInt(chance) == 0) {
            y = this.getRockY(world, x, y, z);
            if (random.nextInt(bigChance) == 0) {
                this.largeRocks(world, random, x, y, z);
            } else {
                this.smallRocks(world, random, x, y, z);
            }
        }
        if (rocksNum > 1) {
            for (int i = 1; i < rocksNum; ++i) {
                if (random.nextInt(chance) != 0) continue;
                int rx = chunkX * 16 + random.nextInt(16);
                int rz = chunkZ * 16 + random.nextInt(16);
                int ry = world.func_72825_h(rx, rz);
                ry = this.getRockY(world, rx, ry, rz);
                if (random.nextInt(bigChance) == 0) {
                    this.largeRocks(world, random, rx, ry, rz);
                    continue;
                }
                this.smallRocks(world, random, rx, ry, rz);
            }
        }
    }

    private int getRockY(World world, int x, int y, int z) {
        if (!world.func_147439_a(x, y, z).func_149662_c()) {
            while (!world.func_147439_a(x, y, z).func_149662_c() && y > 0) {
                --y;
            }
        }
        return y;
    }

    private void smallRocks(World world, Random random, int x, int y, int z) {
        int rockY;
        for (rockY = y; world.func_147439_a(x, rockY, z) != Blocks.field_150348_b && world.func_147439_a(x, rockY, z) != Blocks.field_150322_A && world.func_147439_a(x, rockY, z) != Blocks.field_150349_c && world.func_147439_a(x, rockY, z) != Blocks.field_150346_d && world.func_147439_a(x, rockY, z) != Blocks.field_150354_m && world.func_147439_a(x, rockY, z) != Blocks.field_150351_n && rockY >= y - 5 && rockY > 0; --rockY) {
        }
        if (world.func_147439_a(x, rockY, z).isAir((IBlockAccess)world, x, rockY, z)) {
            return;
        }
        int r = random.nextInt(10);
        if (r <= 1) {
            if (random.nextInt(3) == 0) {
                world.func_147449_b(x, rockY + 1, z, Blocks.field_150348_b);
                if (world.func_147478_e(x, rockY + 2, z, true)) {
                    world.func_147449_b(x, rockY + 2, z, Blocks.field_150431_aC);
                }
            } else if (world.func_147478_e(x, rockY + 1, z, true)) {
                world.func_147449_b(x, rockY + 1, z, Blocks.field_150431_aC);
            }
            if (random.nextInt(3) == 0) {
                world.func_147449_b(x + 1, rockY, z, Blocks.field_150348_b);
                if (world.func_147478_e(x + 1, rockY + 1, z, true)) {
                    world.func_147449_b(x + 1, rockY + 1, z, Blocks.field_150431_aC);
                }
            }
            if (random.nextInt(3) == 0) {
                world.func_147449_b(x - 1, rockY, z, Blocks.field_150348_b);
                if (world.func_147478_e(x - 1, rockY + 1, z, true)) {
                    world.func_147449_b(x - 1, rockY + 1, z, Blocks.field_150431_aC);
                }
            }
            if (random.nextInt(3) == 0) {
                world.func_147449_b(x, rockY, z + 1, Blocks.field_150348_b);
                if (world.func_147478_e(x, rockY + 1, z + 1, true)) {
                    world.func_147449_b(x, rockY + 1, z + 1, Blocks.field_150431_aC);
                }
            }
            if (random.nextInt(3) == 0) {
                world.func_147449_b(x, rockY, z - 1, Blocks.field_150348_b);
                if (world.func_147478_e(x, rockY + 1, z - 1, true)) {
                    world.func_147449_b(x, rockY + 1, z - 1, Blocks.field_150431_aC);
                }
            }
            world.func_147449_b(x, rockY, z, Blocks.field_150348_b);
        } else if (r <= 4) {
            world.func_147449_b(x, rockY, z, Blocks.field_150348_b);
            if (world.func_147478_e(x, rockY + 1, z, true)) {
                world.func_147449_b(x, rockY + 1, z, Blocks.field_150431_aC);
            }
        } else {
            world.func_147449_b(x, rockY, z, Blocks.field_150351_n);
            if (world.func_147478_e(x, rockY + 1, z, true)) {
                world.func_147449_b(x, rockY + 1, z, Blocks.field_150431_aC);
            }
        }
    }

    private void largeRocks(World world, Random random, int x, int y, int z) {
        int rockY;
        for (rockY = y; world.func_147439_a(x, rockY, z) != Blocks.field_150348_b && world.func_147439_a(x, rockY, z) != Blocks.field_150322_A && rockY >= y - 5 && rockY > 0; --rockY) {
        }
        if (world.func_147439_a(x, rockY, z).isAir((IBlockAccess)world, x, rockY, z) || y >= 245) {
            return;
        }
        double r = random.nextDouble() * 2.5 + 2.0;
        this.fillSphere(world, random, x, rockY, z, r);
        int br = (int)Math.ceil(r);
        double heightmult = random.nextDouble() + 2.5;
        for (int dx = -br; dx < br; ++dx) {
            for (int dz = -br; dz < br; ++dz) {
                double rad = Math.sqrt(dx * dx + dz * dz);
                if (!(rad < r)) continue;
                double factor = (r - rad) / r;
                double height = factor * r * heightmult + (double)random.nextInt(3) - 1.0;
                if (dx == 0 && dz == 0) {
                    height -= 2.0;
                }
                int dh = 0;
                dh = 0;
                while ((double)dh < height) {
                    world.func_147449_b(x + dx, rockY + dh, z + dz, Blocks.field_150348_b);
                    ++dh;
                }
                if (!world.func_147478_e(x + dx, rockY + dh, z + dz, true)) continue;
                world.func_147449_b(x + dx, rockY + dh, z + dz, Blocks.field_150431_aC);
            }
        }
        if (br >= 3 && rockY < 200) {
            for (int b = 0; b < 4; ++b) {
                int sz;
                int sy;
                if (random.nextInt(10) > 5) continue;
                WorldGenShrub shrub = new WorldGenShrub(0, 0);
                double angle = (double)(random.nextInt(360) / 360 * 2) * Math.PI;
                int sx = x + (int)((double)br * 1.0 * Math.sin(angle));
                Block block = world.func_147439_a(sx, sy = world.func_72825_h(sx, sz = z + (int)((double)br * 1.0 * Math.cos(angle))), sz);
                if (block == Blocks.field_150355_j) continue;
                shrub.func_76484_a(world, random, sx, sy, sz);
            }
        }
    }

    private void fillSphere(World world, Random random, int x, int y, int z, double radius) {
        int br = (int)Math.ceil(radius);
        for (int dx = -br; dx < br; ++dx) {
            for (int dz = -br; dz < br; ++dz) {
                for (int dy = -br; dy < br; ++dy) {
                    double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    Block block = world.func_147439_a(x + dx, y + dy, z + dz);
                    if (!(d < radius) || block == Blocks.field_150343_Z || block == Blocks.field_150357_h) continue;
                    world.func_147449_b(x + dx, y + dy, z + dz, Blocks.field_150348_b);
                }
            }
        }
    }
}

