/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.feature;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import ttftcuts.atg.ATG;
import ttftcuts.atg.utils.ATGUtils;

public class ATGWorldGenCliffs
implements IWorldGenerator {
    private static final double density = 0.2;
    private static final Block cliffBlock = Blocks.field_150405_ch;
    private static final int offset = 3;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!ATG.isATG(world)) {
            return;
        }
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                if (world.func_72959_q().func_76935_a((int)(chunkX * 16 + x), (int)(chunkZ * 16 + z)).field_76756_M != BiomeGenBase.field_76789_p.field_76756_M) continue;
                this.decorateCliffs(world, random, chunkX, chunkZ, x, z);
            }
        }
    }

    private void decorateCliffs(World world, Random random, int chunkX, int chunkZ, int x, int z) {
        int diff;
        int height;
        int realx = chunkX * 16 + x;
        int realz = chunkZ * 16 + z;
        int west = height = ATGUtils.getTopBlock(world, realx, realz);
        if (x > 0) {
            west = ATGUtils.getTopBlock(world, realx - 1, realz);
        }
        int east = height;
        if (x < 15) {
            east = ATGUtils.getTopBlock(world, realx + 1, realz);
        }
        int north = height;
        if (z > 0) {
            north = ATGUtils.getTopBlock(world, realx, realz - 1);
        }
        int south = height;
        if (z < 15) {
            south = ATGUtils.getTopBlock(world, realx, realz + 1);
        }
        if ((diff = Math.max(Math.max(Math.max(height - north, height - south), height - east), height - west)) > 5) {
            int i = 0;
            while (true) {
                double d = i;
                double d2 = random.nextBoolean() ? Math.ceil((double)diff * 0.2) : Math.floor((double)diff * 0.2);
                if (!(d < d2)) break;
                int placeheight = height - 3 - random.nextInt(diff - 3);
                int cx = realx;
                int cz = realz;
                world.func_147449_b(cx + 1, placeheight, cz, cliffBlock);
                world.func_147449_b(cx - 1, placeheight, cz, cliffBlock);
                world.func_147449_b(cx, placeheight, cz + 1, cliffBlock);
                world.func_147449_b(cx, placeheight, cz - 1, cliffBlock);
                if (random.nextDouble() > 0.5) {
                    world.func_147449_b(cx + 1, placeheight, cz + 1, cliffBlock);
                }
                if (random.nextDouble() > 0.5) {
                    world.func_147449_b(cx - 1, placeheight, cz + 1, cliffBlock);
                }
                if (random.nextDouble() > 0.5) {
                    world.func_147449_b(cx + 1, placeheight, cz - 1, cliffBlock);
                }
                if (random.nextDouble() > 0.5) {
                    world.func_147449_b(cx - 1, placeheight, cz - 1, cliffBlock);
                }
                if (random.nextDouble() > 0.9) {
                    world.func_147449_b(cx + 2, placeheight, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.9) {
                    world.func_147449_b(cx - 2, placeheight, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.9) {
                    world.func_147449_b(cx, placeheight, cz + 2, cliffBlock);
                }
                if (random.nextDouble() > 0.9) {
                    world.func_147449_b(cx, placeheight, cz - 2, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx + 1, placeheight + 1, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx - 1, placeheight + 1, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx, placeheight + 1, cz + 1, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx, placeheight + 1, cz - 1, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx + 1, placeheight - 1, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx - 1, placeheight - 1, cz, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx, placeheight - 1, cz + 1, cliffBlock);
                }
                if (random.nextDouble() > 0.7) {
                    world.func_147449_b(cx, placeheight - 1, cz - 1, cliffBlock);
                }
                ++i;
            }
            int baseheight = height - diff;
            world.func_147449_b(realx + 1, baseheight, realz, cliffBlock);
            world.func_147449_b(realx - 1, baseheight, realz, cliffBlock);
            world.func_147449_b(realx, baseheight, realz + 1, cliffBlock);
            world.func_147449_b(realx, baseheight, realz - 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight, realz - 1, cliffBlock);
            world.func_147449_b(realx - 1, baseheight, realz - 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight, realz + 1, cliffBlock);
            world.func_147449_b(realx - 1, baseheight, realz + 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight + 1, realz, cliffBlock);
            world.func_147449_b(realx - 1, baseheight + 1, realz, cliffBlock);
            world.func_147449_b(realx, baseheight + 1, realz + 1, cliffBlock);
            world.func_147449_b(realx, baseheight + 1, realz - 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight + 1, realz - 1, cliffBlock);
            world.func_147449_b(realx - 1, baseheight + 1, realz - 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight + 1, realz + 1, cliffBlock);
            world.func_147449_b(realx - 1, baseheight + 1, realz + 1, cliffBlock);
            world.func_147449_b(realx + 2, baseheight, realz - 1, cliffBlock);
            world.func_147449_b(realx + 2, baseheight, realz, cliffBlock);
            world.func_147449_b(realx + 2, baseheight, realz + 1, cliffBlock);
            world.func_147449_b(realx - 2, baseheight, realz - 1, cliffBlock);
            world.func_147449_b(realx - 2, baseheight, realz, cliffBlock);
            world.func_147449_b(realx - 2, baseheight, realz + 1, cliffBlock);
            world.func_147449_b(realx + 1, baseheight, realz - 2, cliffBlock);
            world.func_147449_b(realx, baseheight, realz - 2, cliffBlock);
            world.func_147449_b(realx - 1, baseheight, realz - 2, cliffBlock);
            world.func_147449_b(realx + 1, baseheight, realz + 2, cliffBlock);
            world.func_147449_b(realx, baseheight, realz + 2, cliffBlock);
            world.func_147449_b(realx - 1, baseheight, realz + 2, cliffBlock);
        }
    }
}

