/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.config.configfiles;

import com.google.common.base.Optional;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import ttftcuts.atg.api.ATGAPI;

public class ATGMainConfig {
    public static Configuration config;
    public static Property doBiomeIDCheck;
    public static Property genMagmaShafts;
    public static Property genRocks;
    public static Property genRivers;
    public static Property genHighAltitudeOres;
    public static Property ATGWorldID;
    public static Property biomeIDGravelBeach;
    public static Property biomeIDShrubland;
    public static Property biomeIDSnowyBeach;
    public static Property biomeIDSteppe;
    public static Property biomeIDTropicalShrubland;
    public static Property biomeIDTundra;
    public static Property biomeIDVolcano;
    public static Property biomeIDWoodland;
    public static Property genModHeight;
    public static Property genModTemp;
    public static Property genModRain;
    public static Property genModHeightMult;
    public static Property genModTempMult;
    public static Property genModRainMult;
    public static Property genModHeightScale;
    public static Property genModTempScale;
    public static Property genModRainScale;
    public static Property genModSeaLevel;
    public static Property genModBlobScale;
    public static Property useClimate;
    public static Property climatePeriod;
    public static Property climateMin;
    public static Property climateMax;
    public static Property climateType;
    public static Property climateCentre;
    public static Property useImageMap;
    public static Property imageMapFile;
    public static Property imageMapScale;
    public static Property imageMapHeightMult;
    public static Property imageMapHeight;
    public static Property imageMapTempMult;
    public static Property imageMapTemp;
    public static Property imageMapRainMult;
    public static Property imageMapRain;
    public static Property imageMapLooping;
    public static Property imageMapFade;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configfile) {
        config = new Configuration(configfile);
        try {
            config.load();
            genMagmaShafts = config.get("features", "VolcanoMagmaShafts", true);
            ATGMainConfig.genMagmaShafts.comment = "Set to false to replace the magma in volcanoes with cobble. Does not disable the volcano biome.";
            genRocks = config.get("features", "Boulders", true);
            ATGMainConfig.genRocks.comment = "Generates boulders and rocks to add interest. A major feature of volcanoes.";
            genRivers = config.get("features", "Rivers", true);
            ATGMainConfig.genRivers.comment = "Generate flowing rivers which follow the terrain. Can sometimes be messy.";
            genHighAltitudeOres = config.get("features", "HighAltitudeOres", true);
            ATGMainConfig.genHighAltitudeOres.comment = "Adds coal, iron, gold and emeralds to mountain peaks. Disable if you want to use a different mod to manage ore generation.";
            ATGWorldID = config.get("biomeids", "ATGWorldID", 9);
            ATGMainConfig.ATGWorldID.comment = "World ID for ATG. Don't change this unless you are having problems.";
            biomeIDGravelBeach = config.get("biomeids", "GravelBeach", 141);
            ATGMainConfig.biomeIDGravelBeach.comment = "Set to 0 to disable a biome entirely. Do NOT disable biomes on a generated world!";
            biomeIDShrubland = config.get("biomeids", "Shrubland", 142);
            biomeIDSnowyBeach = config.get("biomeids", "SnowyBeach", 143);
            biomeIDSteppe = config.get("biomeids", "Steppe", 144);
            biomeIDTropicalShrubland = config.get("biomeids", "TropicalShrubland", 145);
            biomeIDTundra = config.get("biomeids", "Tundra", 146);
            biomeIDVolcano = config.get("biomeids", "Volcano", 147);
            biomeIDWoodland = config.get("biomeids", "Woodland", 148);
            genModHeight = config.get("generator", "HeightOffset", 0.0);
            ATGMainConfig.genModHeight.comment = "Flat modifier to height generation, added to the height of the world, in blocks. 1.0 = 255 blocks. Try values like +/-0.03. Default: 0.0.";
            genModTemp = config.get("generator", "TemperatureOffset", 0.0);
            ATGMainConfig.genModTemp.comment = "Flat modifier to temperature, added to the global temperature map. Positive is hotter, negetive is colder. 1.0 = desert. Try values like +/-0.1. Not valid for climate mode. Default: 0.0.";
            genModRain = config.get("generator", "MoistureOffset", 0.0);
            ATGMainConfig.genModRain.comment = "Flat modifier to moisture, added to global noisture. Positive means wetter, negetive means dryer. 1.0 = jungle/swamp. Try values like +/-0.1. Default: 0.0.";
            genModHeightMult = config.get("generator", "HeightMultiplier", 1.0);
            ATGMainConfig.genModHeightMult.comment = "Multiplier for height generation. The base height generated is multiplied by this - lower means lower peaks and smoother slopes, higher means more tall mountains, and more chance of volcanoes. 0.0 = all bedrock. Best used to counter negative offsets. Default: 1.0.";
            genModTempMult = config.get("generator", "TemperatureMultiplier", 1.0);
            ATGMainConfig.genModTempMult.comment = "Multiplier for temperature generation. Increase this for more drastic temperature differences, reduce to make the world temperature more even. 0.0 = all ice. Not valid for climate mode. Default: 1.0.";
            genModRainMult = config.get("generator", "MoistureMultiplier", 1.0);
            ATGMainConfig.genModRainMult.comment = "Multiplier for moisture generation. Increase for more variation in the moisture of biomes, reduce to make them more even. 0.0 = all dry. Default: 1.0.";
            genModHeightScale = config.get("generator", "HeightNoiseScale", 1.0);
            ATGMainConfig.genModHeightScale.comment = "Scale modifier for the terrain height noise field. Controls the x/z scale of the terrain. Increase to spread out the land, meaning smoother slopes with no net height change, reduce to make things steeper. Default: 1.0.";
            genModTempScale = config.get("generator", "TemperatureNoiseScale", 1.0);
            ATGMainConfig.genModTempScale.comment = "Scale modifier for the temperature noise field. Increasing this makes the temperature gradient bigger, meaning you have to travel further to see a change in temperature. Default: 1.0.";
            genModRainScale = config.get("generator", "MoistureNoiseScale", 1.0);
            ATGMainConfig.genModRainScale.comment = "Scale modifier for the moisture noise field. Like the temerature scale, but for the moisture map. Reducing this makes moisture patches smaller. Default: 1.0.";
            genModSeaLevel = config.get("generator", "SeaLevel", 63);
            ATGMainConfig.genModSeaLevel.comment = "Sea level, in blocks. Default: 63 (same as vanilla)";
            genModBlobScale = config.get("generator", "BiomeBlobScale", 4);
            ATGMainConfig.genModBlobScale.comment = "Scale value for biome sub-blobs. Controls the size of biomes *within* biome groups, NOT the biome groups themselves. This has essentially no effect without additional biome mods, but with them it controls the area of terrain that might be one type of forest instead of another type, within a forested zone. Adding one doubles the biome size, subtracting 1 halves it. Minimum: 1, Default: 4.";
            useClimate = config.get("climate", "UseClimate", false);
            ATGMainConfig.useClimate.comment = "Use alternating bands of hot and cold to simulate the poles and equator. Overrides generator settings for temperature.";
            climatePeriod = config.get("climate", "ClimatePeriod", 10000);
            ATGMainConfig.climatePeriod.comment = "Distance in blocks from pole to pole. Temperature gradient repeats beyond this. Default: 10000.";
            climateMin = config.get("climate", "ClimateMinTemp", 0.4);
            ATGMainConfig.climateMin.comment = "Minimum BASE (before height) temperature for the climate gradient, found at the poles. Default: 0.4.";
            climateMax = config.get("climate", "ClimateMaxTemp", 0.9);
            ATGMainConfig.climateMax.comment = "Maximum BASE (before height) temperature for the climate gradient, found at the equator. Default: 0.9.";
            climateType = config.get("climate", "ClimateType", 0);
            ATGMainConfig.climateType.comment = "Climate type - 0: Looping. 1: Cold-hot-cold, cold continues to north and south. 2: Cold-hot, cold continues north, hot continues south.";
            climateCentre = config.get("climate", "ClimateCentre", false);
            ATGMainConfig.climateCentre.comment = "Set to true to make sure 0,0 lies in a temperate zone.";
            useImageMap = config.get("imagemap", "UseImageMap", false);
            ATGMainConfig.useImageMap.comment = "EXPERIMENTAL AND INCOMPLETE - USE AT YOUR OWN RISK!  Use a source image to generate a map. Other settings will take effect outside unless looping is enabled.";
            imageMapFile = config.get("imagemap", "MapFile", "");
            ATGMainConfig.imageMapFile.comment = "Name of a png file in the maps config subfolder. Red, green and blue channels represent height, temperature and moisture maps respectively.";
            imageMapScale = config.get("imagemap", "MapScale", 32.0);
            ATGMainConfig.imageMapScale.comment = "Number of blocks represented by each pixel of the map image.";
            imageMapHeightMult = config.get("imagemap", "HeightMultiplier", 1.0);
            ATGMainConfig.imageMapHeightMult.comment = "Height multiplier for the processed image map. Default: 1.0.";
            imageMapHeight = config.get("imagemap", "HeightOffset", 0.0);
            ATGMainConfig.imageMapHeight.comment = "Height offset for the processed image map. Ranges 0-1. Default: 0.0.";
            imageMapTempMult = config.get("imagemap", "TemperatureMultiplier", 1.0);
            ATGMainConfig.imageMapTempMult.comment = "Temperature multiplier for the processed image map. Default: 1.0.";
            imageMapTemp = config.get("imagemap", "TemperatureOffset", 0.0);
            ATGMainConfig.imageMapTemp.comment = "Temperature offset for the processed image map. Ranges 0-1. Default: 0.0.";
            imageMapRainMult = config.get("imagemap", "MoistureMultiplier", 1.0);
            ATGMainConfig.imageMapRainMult.comment = "Moisture multiplier for the processed image map. Default: 1.0.";
            imageMapRain = config.get("imagemap", "MoistureOffset", 0.0);
            ATGMainConfig.imageMapRain.comment = "Moisture offset for the processed image map. Ranges 0-1. Default: 0.0.";
            imageMapLooping = config.get("imagemap", "MapLooping", false);
            ATGMainConfig.imageMapLooping.comment = "Set to true to have the image map repeat instead of fading back to normal terrain.";
            imageMapFade = config.get("imagemap", "MapEdgeFade", 160);
            ATGMainConfig.imageMapFade.comment = "Number of blocks to fade from the edge of the image to normal generation. Ignored if looping is enabled. Default: 160.";
            ATGAPI.sealevel = Optional.of((Object)genModSeaLevel.getInt(63));
        }
        catch (Exception e) {
            System.out.println("ATG: Failed to load config!");
            e.printStackTrace();
            ATGAPI.sealevel = Optional.of((Object)63);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

