/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.biome;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.config.configfiles.ATGBiomeConfig;
import ttftcuts.atg.gen.ATGBiomeManager;
import ttftcuts.atg.gen.ATGBiomeMod;
import ttftcuts.atg.gen.ATGGenLayerBlobs;
import ttftcuts.atg.utils.ATGUtils;

public class ATGBiomeGroup {
    public String name;
    public double temp;
    public double rainfall;
    public double height;
    public double minHeight;
    public double maxHeight;
    public long blobsalt;
    public boolean generate;
    public int ox = 0;
    public int oz = 0;
    public double suitability = 0.0;
    private Map<Integer, Double> biomes;
    private NavigableMap<Double, BiomeGenBase> biomesFinal;
    private double totalWeight;

    public ATGBiomeGroup(String name, double temp, double rainfall, double height, double minHeight, double maxHeight, long blobsalt, boolean generate) {
        this.name = name;
        this.temp = temp;
        this.rainfall = rainfall;
        this.height = height;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.blobsalt = blobsalt;
        this.generate = generate;
        this.ox = (int)(ATGUtils.xorShift64(2846L * ATGUtils.xorShift64(blobsalt + 7391834L) - blobsalt) % Integer.MAX_VALUE);
        this.oz = (int)(ATGUtils.xorShift64(9672L * ATGUtils.xorShift64(blobsalt + 4517384L) - blobsalt) % Integer.MAX_VALUE);
        this.biomes = new TreeMap<Integer, Double>();
    }

    public ATGBiomeGroup(String name, double temp, double rainfall, long blobsalt) {
        this(name, temp, rainfall, 0.5, blobsalt);
    }

    public ATGBiomeGroup(String name, double temp, double rainfall, double height, long blobsalt) {
        this(name, temp, rainfall, height, 0.0, 1.0, blobsalt, true);
    }

    public ATGBiomeGroup(String name, double temp, double rainfall, long blobsalt, boolean generate) {
        this(name, temp, rainfall, 0.5, blobsalt, generate);
    }

    public ATGBiomeGroup(String name, double temp, double rainfall, double height, long blobsalt, boolean generate) {
        this(name, temp, rainfall, height, 0.0, 1.0, blobsalt, generate);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.biomesFinal.size();
    }

    public boolean containsBiome(BiomeGenBase biome) {
        return this.biomesFinal.containsValue(biome);
    }

    public ATGBiomeGroup modSuitability(double suitability) {
        this.suitability = suitability;
        return this;
    }

    public ATGBiomeGroup addBiome(BiomeGenBase biome, double weight, ATGBiomeMod mod) {
        this.addBiome(biome, weight);
        ATGBiomeManager.setBiomeMod(biome, mod);
        return this;
    }

    public ATGBiomeGroup addBiome(BiomeGenBase biome, double weight) {
        if (biome != null) {
            if (this.biomes.containsKey(biome.field_76756_M)) {
                this.biomes.put(biome.field_76756_M, this.biomes.get(biome) + weight);
            } else {
                this.biomes.put(biome.field_76756_M, weight);
            }
        }
        return this;
    }

    public ATGBiomeGroup addBiome(BiomeGenBase biome) {
        this.addBiome(biome, 1.0);
        return this;
    }

    public ATGBiomeGroup addBiome(BiomeGenBase biome, ATGBiomeMod mod) {
        this.addBiome(biome, 1.0, mod);
        return this;
    }

    public ATGBiomeGroup removeBiome(BiomeGenBase biome) {
        if (biome != null) {
            this.biomes.remove(biome.field_76756_M);
        }
        return this;
    }

    public ATGBiomeGroup replaceBiome(BiomeGenBase old, BiomeGenBase replacement, double weight) {
        this.removeBiome(old);
        this.addBiome(replacement, weight);
        return this;
    }

    public ATGBiomeGroup replaceBiome(BiomeGenBase old, BiomeGenBase replacement, double weight, ATGBiomeMod mod) {
        this.replaceBiome(old, replacement, weight);
        ATGBiomeManager.setBiomeMod(replacement, mod);
        return this;
    }

    public ATGBiomeGroup replaceBiome(BiomeGenBase old, BiomeGenBase replacement) {
        this.removeBiome(old);
        this.addBiome(replacement);
        return this;
    }

    public ATGBiomeGroup replaceBiome(BiomeGenBase old, BiomeGenBase replacement, ATGBiomeMod mod) {
        this.removeBiome(old);
        this.addBiome(replacement, mod);
        return this;
    }

    public void process() {
        if (this.biomesFinal == null) {
            this.biomesFinal = new TreeMap<Double, BiomeGenBase>();
            this.totalWeight = 0.0;
            BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
            for (Map.Entry<Integer, Double> entry : this.biomes.entrySet()) {
                if (!ATGBiomeConfig.generate[entry.getKey()].getBoolean(true) || !(ATGBiomeConfig.biomeChance[entry.getKey()].getDouble(1.0) > 0.0)) continue;
                this.totalWeight += entry.getValue() * ATGBiomeConfig.biomeChance[entry.getKey()].getDouble(1.0);
                this.biomesFinal.put(this.totalWeight, biomeList[entry.getKey()]);
            }
        }
    }

    public BiomeGenBase getBiome(int random) {
        BiomeGenBase subBiome;
        this.process();
        int nbiome = random & (int)Math.pow(2.0, 16.0) - 1;
        int nsub = random & (int)Math.pow(2.0, 14.0) - 1 << 16;
        nsub >>= 16;
        double biomeno = (double)nbiome * this.totalWeight / (double)ATGGenLayerBlobs.granularity;
        if (this.biomesFinal.isEmpty()) {
            System.out.println("ATG: Biome group " + this.name + " is empty but being queried! Returning plains as fallback.");
            return BiomeGenBase.field_76772_c;
        }
        BiomeGenBase biome = BiomeGenBase.field_76772_c;
        try {
            biome = this.biomesFinal.ceilingEntry(biomeno).getValue();
        }
        catch (NullPointerException e) {
            System.out.println("ATG: Something went wrong when getting a suitable biome from the " + this.name + " biome group:");
            e.printStackTrace();
            return BiomeGenBase.field_76772_c;
        }
        ATGBiomeMod mod = ATGBiomeManager.getMod(biome);
        if (mod != null && (subBiome = mod.getSubBiome((double)nsub / (double)ATGGenLayerBlobs.subgranularity)) != null) {
            biome = subBiome;
        }
        return biome;
    }
}

